/*
 * Decompiled with CFR 0.152.
 */
package org.powerassert;

import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.powerassert.PowerAssertScanner;

@SupportedAnnotationTypes(value={"*"})
public class PowerAssertProcessor
extends AbstractProcessor {
    private Trees trees;
    private Context context;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        if (!this.isInitialized()) {
            super.init(processingEnv);
        }
        this.messager = processingEnv.getMessager();
        try {
            this.trees = Trees.instance(processingEnv);
            this.context = ((JavacProcessingEnvironment)processingEnv).getContext();
        }
        catch (NoClassDefFoundError ignored) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Unable to generate power assertions because javac is not compiling the code");
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.trees == null) {
            return false;
        }
        if (!roundEnv.processingOver()) {
            for (Element element : roundEnv.getRootElements()) {
                try {
                    CharSequence source = ((Symbol.ClassSymbol)element).sourcefile.getCharContent(true);
                    TreePath path = this.trees.getPath(element);
                    new PowerAssertScanner(source, this.messager).scan(path, this.context);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.values()[SourceVersion.values().length - 1];
    }
}

