/*
 * Decompiled with CFR 0.152.
 */
package org.powerassert;

import com.sun.source.tree.AssertTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import javax.annotation.processing.Messager;

class PowerAssertScanner
extends TreePathScanner<TreePath, Context> {
    TreeMaker treeMaker;
    JavacElements elements;
    Messager messager;
    CharSequence rawSource;

    public PowerAssertScanner(CharSequence rawSource, Messager messager) {
        this.rawSource = rawSource;
        this.messager = messager;
    }

    @Override
    public TreePath scan(TreePath path, Context context) {
        this.treeMaker = TreeMaker.instance(context);
        this.elements = JavacElements.instance(context);
        return (TreePath)super.scan(path, context);
    }

    @Override
    public TreePath visitAssert(AssertTree node, Context context) {
        JCTree.JCAssert assertNode = (JCTree.JCAssert)node;
        JCTree.JCExpression powerAssertType = this.qualifiedName("org", "powerassert", "synthetic", "PowerAssert");
        JCTree.JCExpression recorderRuntimeType = this.qualifiedName("org", "powerassert", "synthetic", "RecorderRuntime");
        JCTree.JCVariableDecl powerAssert = this.treeMaker.VarDef(this.treeMaker.Modifiers(16L), this.name("$org_powerassert_powerAssert"), powerAssertType, this.treeMaker.NewClass(null, List.nil(), powerAssertType, List.nil(), null));
        JCTree.JCVariableDecl recorderRuntime = this.treeMaker.VarDef(this.treeMaker.Modifiers(16L), this.name("$org_powerassert_recorderRuntime"), recorderRuntimeType, this.treeMaker.NewClass(null, List.nil(), recorderRuntimeType, List.of(this.treeMaker.Apply(List.nil(), this.qualifiedName("$org_powerassert_powerAssert", "getListener"), List.nil())), null));
        JCTree.JCExpression instrumented = this.recordAllValues(assertNode.getCondition(), null);
        JCTree.JCExpressionStatement recordExpr = this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), this.qualifiedName("$org_powerassert_recorderRuntime", "recordExpression"), List.of(this.treeMaker.Literal(this.source(assertNode.getCondition())), instrumented, this.treeMaker.Literal(assertNode.getCondition().getStartPosition()))));
        recordExpr.setPos(assertNode.getCondition().pos);
        JCTree.JCBlock powerAssertBlock = this.treeMaker.Block(0L, List.of(powerAssert, recorderRuntime, recordExpr, new JCTree.JCStatement[]{this.completeRecording(), (JCTree.JCStatement)((Object)node)}));
        JCTree.JCBlock parent = (JCTree.JCBlock)this.getCurrentPath().getParentPath().getLeaf();
        parent.stats = this.replaceStatement((List<JCTree.JCStatement>)parent.getStatements(), (JCTree.JCAssert)node, powerAssertBlock);
        return null;
    }

    public JCTree.JCExpression recordAllValues(JCTree.JCExpression expr, JCTree.JCExpression parent) {
        if (expr instanceof JCTree.JCBinary) {
            JCTree.JCBinary binary = (JCTree.JCBinary)expr;
            return this.recordValue(this.treeMaker.Binary(binary.getTag(), this.recordAllValues(binary.getLeftOperand(), expr), this.recordAllValues(binary.getRightOperand(), expr)).setPos(binary.pos), binary.getRightOperand().pos - 2);
        }
        if (expr instanceof JCTree.JCUnary) {
            JCTree.JCUnary unary = (JCTree.JCUnary)expr;
            return this.recordValue(this.treeMaker.Unary(unary.getTag(), this.recordAllValues(unary.getExpression(), expr)).setPos(unary.pos), unary.getExpression().pos - 1);
        }
        if (expr instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation method = (JCTree.JCMethodInvocation)expr;
            return this.recordValue(this.treeMaker.Apply(method.typeargs, this.recordAllValues(method.getMethodSelect(), expr), this.recordArgs(method.args, expr)).setPos(method.pos), method.getMethodSelect().pos + 1);
        }
        if (expr instanceof JCTree.JCIdent) {
            boolean staticMethodTarget;
            String name = ((JCTree.JCIdent)expr).getName().toString();
            boolean bl = staticMethodTarget = this.elements.getTypeElement(name) != null || this.elements.getTypeElement("java.lang." + name) != null;
            if (!staticMethodTarget && !(parent instanceof JCTree.JCMethodInvocation)) {
                return this.recordValue(expr, expr.pos);
            }
            return expr;
        }
        if (expr instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess field = (JCTree.JCFieldAccess)expr;
            if (!(field.selected instanceof JCTree.JCLiteral)) {
                JCTree.JCExpression recordedField = this.treeMaker.Select(this.recordAllValues(field.getExpression(), expr), field.name).setPos(field.pos);
                if (parent != null && parent instanceof JCTree.JCMethodInvocation) {
                    return recordedField;
                }
                return this.recordValue(recordedField, expr.pos + 1);
            }
            return expr;
        }
        if (expr instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass newClass = (JCTree.JCNewClass)expr;
            return this.treeMaker.NewClass(this.recordAllValues(newClass.encl, expr), newClass.typeargs, newClass.clazz, this.recordArgs(newClass.args, expr), newClass.def).setPos(newClass.pos);
        }
        if (expr instanceof JCTree.JCArrayAccess) {
            JCTree.JCArrayAccess arrayAccess = (JCTree.JCArrayAccess)expr;
            return this.recordValue(this.treeMaker.Indexed(this.recordAllValues(arrayAccess.getExpression(), expr), this.recordAllValues(arrayAccess.getIndex(), expr)).setPos(arrayAccess.pos), expr.pos);
        }
        if (expr instanceof JCTree.JCNewArray) {
            JCTree.JCNewArray newArray = (JCTree.JCNewArray)expr;
            return this.treeMaker.NewArray(this.recordAllValues(newArray.getType(), expr), this.recordArgs((List<JCTree.JCExpression>)newArray.getDimensions(), expr), this.recordArgs((List<JCTree.JCExpression>)newArray.getInitializers(), expr)).setPos(newArray.pos);
        }
        if (expr instanceof JCTree.JCConditional) {
            JCTree.JCConditional conditional = (JCTree.JCConditional)expr;
            return this.recordValue(this.treeMaker.Conditional(this.recordAllValues(conditional.getCondition(), expr), this.recordAllValues(conditional.getTrueExpression(), expr), this.recordAllValues(conditional.getFalseExpression(), expr)).setPos(conditional.pos), expr.pos);
        }
        return expr;
    }

    private JCTree.JCExpression recordValue(JCTree.JCExpression expr, int anchor) {
        return this.treeMaker.Apply(List.nil(), this.qualifiedName("$org_powerassert_recorderRuntime", "recordValue"), List.of(expr, this.treeMaker.Literal(anchor)));
    }

    private JCTree.JCExpressionStatement completeRecording() {
        return this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), this.qualifiedName("$org_powerassert_recorderRuntime", "completeRecording"), List.nil()));
    }

    private JCTree.JCExpression qualifiedName(String ... name) {
        JCTree.JCExpression prior = this.treeMaker.Ident(this.elements.getName(name[0]));
        for (int i = 1; i < name.length; ++i) {
            prior = this.treeMaker.Select(prior, this.elements.getName(name[i]));
        }
        return prior;
    }

    private Name name(String name) {
        return this.elements.getName(name);
    }

    private JCTree.JCStatement debugPrint(JCTree.JCExpression expr) {
        return this.treeMaker.Exec(this.treeMaker.Apply(List.nil(), this.qualifiedName("System", "out", "println"), List.of(expr)));
    }

    private List<JCTree.JCStatement> replaceStatement(List<JCTree.JCStatement> list, JCTree.JCStatement replace, JCTree.JCStatement with) {
        JCTree.JCStatement[] stats = list.toArray(new JCTree.JCStatement[list.size()]);
        for (int i = 0; i < stats.length; ++i) {
            if (stats[i] != replace) continue;
            stats[i] = with;
            break;
        }
        return List.from(stats);
    }

    private String source(JCTree.JCExpression expr) {
        String exprStr = expr.toString();
        int sourcePos = expr.getStartPosition();
        int exprPos = 0;
        while (exprPos < exprStr.length()) {
            char exprChar = exprStr.charAt(exprPos);
            char sourceChar = this.rawSource.charAt(sourcePos);
            if (Character.isWhitespace(exprChar)) {
                ++exprPos;
                continue;
            }
            if (Character.isWhitespace(sourceChar)) {
                ++sourcePos;
                continue;
            }
            ++exprPos;
            ++sourcePos;
        }
        return this.rawSource.subSequence(expr.getStartPosition(), sourcePos).toString();
    }

    private List<JCTree.JCExpression> recordArgs(List<JCTree.JCExpression> args, JCTree.JCExpression parent) {
        JCTree.JCExpression[] recordedArgs = new JCTree.JCExpression[args.length()];
        for (int i = 0; i < args.length(); ++i) {
            recordedArgs[i] = this.recordAllValues(args.get(i), parent);
        }
        return List.from(recordedArgs);
    }
}

