/*
 * Decompiled with CFR 0.152.
 */
package org.powerassert.synthetic;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.powerassert.commons.lang.builder.ToStringBuilder;
import org.powerassert.commons.lang.builder.ToStringStyle;
import org.powerassert.synthetic.RecordedExpression;
import org.powerassert.synthetic.RecordedValue;

public class ExpressionRenderer {
    boolean showTypes;

    public ExpressionRenderer(boolean showTypes) {
        this.showTypes = showTypes;
    }

    public String render(RecordedExpression<?> recordedExpr) {
        int offset = 0;
        for (char c : recordedExpr.getText().toCharArray()) {
            if (!Character.isWhitespace(c)) break;
            ++offset;
        }
        String intro = recordedExpr.getText().trim().replaceAll(";$", "");
        ArrayList<String> lines = new ArrayList<String>();
        for (RecordedValue recordedValue : this.filterAndSortByAnchor(recordedExpr.getValues())) {
            this.placeValue(lines, recordedValue.getValue(), recordedValue.getAnchor() - offset);
        }
        lines.add(0, intro);
        String rendered = "";
        for (String line : lines) {
            rendered = rendered + line + "\n";
        }
        return rendered;
    }

    private Iterable<RecordedValue> filterAndSortByAnchor(List<RecordedValue> recordedValues) {
        TreeMap<Integer, RecordedValue> map = new TreeMap<Integer, RecordedValue>(new Comparator<Integer>(){

            @Override
            public int compare(Integer n1, Integer n2) {
                return n2.compareTo(n1);
            }
        });
        for (RecordedValue value : recordedValues) {
            if (map.containsKey(value.getAnchor())) continue;
            map.put(value.getAnchor(), value);
        }
        return map.values();
    }

    private void placeValue(List<String> lines, Object value, int col) {
        String str = this.renderValue(value);
        if (lines.isEmpty()) {
            lines.add("");
        }
        lines.set(0, this.placeString(lines.get(0), "|", col));
        for (int i = 1; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (this.fits(line, str, col).booleanValue()) {
                lines.set(i, this.placeString(line, str, col));
                return;
            }
            lines.set(i, this.placeString(line, "|", col));
        }
        String newLine = this.placeString("", str, col);
        lines.add(newLine);
    }

    private String renderValue(Object value) {
        String str;
        if (value == null) {
            str = "null";
        } else if (value.getClass().isArray()) {
            str = "[";
            for (Object o : this.toArray(value)) {
                str = str + this.renderValue(o) + ", ";
            }
            str = (str.length() > 1 ? str.substring(0, str.length() - 2) : "") + "]";
        } else {
            try {
                str = value.getClass().getMethod("toString", new Class[0]).getDeclaringClass() == Object.class ? ToStringBuilder.reflectionToString(value, ToStringStyle.SHORT_PREFIX_STYLE) : value.toString();
            }
            catch (NoSuchMethodException e) {
                str = value.toString();
            }
        }
        return this.showTypes && value != null ? str + " (" + value.getClass().getName() + ")" : str;
    }

    private String placeString(String line, String str, int anchor) {
        int diff = anchor - line.length();
        for (int i = 0; i < diff; ++i) {
            line = line + ' ';
        }
        String prefix = line.substring(0, anchor);
        String suffix = anchor + str.length() > line.length() ? "" : line.substring(anchor + str.length());
        return prefix + str + suffix;
    }

    private Boolean fits(String line, String str, int anchor) {
        if (str.length() > line.length()) {
            return false;
        }
        for (char c : line.substring(anchor, anchor + str.length() + 1).toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private Object[] toArray(Object array) {
        if (array.getClass().getComponentType().isPrimitive()) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(array); ++i) {
                list.add(Array.get(array, i));
            }
            return list.toArray();
        }
        return (Object[])array;
    }
}

