/*
 * Decompiled with CFR 0.152.
 */
package org.powerassert.synthetic;

import java.util.ArrayList;
import org.powerassert.synthetic.ExpressionRenderer;
import org.powerassert.synthetic.RecordedExpression;
import org.powerassert.synthetic.RecordedValue;
import org.powerassert.synthetic.RecorderListener;
import org.powerassert.synthetic.Recording;

public class PowerAssert {
    private boolean failEarly = true;
    private boolean showTypes = false;
    private boolean printExprs = false;
    private RecorderListener<Boolean> listener = new RecorderListener<Boolean>(){

        @Override
        public void valueRecorded(RecordedValue recordedValue) {
        }

        @Override
        public void expressionRecorded(RecordedExpression<Boolean> recordedExpr) {
            if (PowerAssert.this.printExprs) {
                System.out.println(new ExpressionRenderer(PowerAssert.this.showTypes).render(recordedExpr));
            }
            if (!recordedExpr.getValue().booleanValue() && PowerAssert.this.failEarly) {
                throw new AssertionError((Object)("\n\n" + new ExpressionRenderer(PowerAssert.this.showTypes).render(recordedExpr)));
            }
        }

        @Override
        public void recordingCompleted(Recording<Boolean> recording) {
            if (!PowerAssert.this.failEarly) {
                ArrayList<RecordedExpression<Boolean>> failedExprs = new ArrayList<RecordedExpression<Boolean>>();
                for (RecordedExpression<Boolean> expr : recording.getRecordedExprs()) {
                    if (expr.getValue().booleanValue()) continue;
                    failedExprs.add(expr);
                }
                if (!failedExprs.isEmpty()) {
                    ExpressionRenderer renderer = new ExpressionRenderer(PowerAssert.this.showTypes);
                    String rendering = "";
                    for (int i = failedExprs.size() - 1; i >= 0; --i) {
                        rendering = rendering + "\n\n" + renderer.render((RecordedExpression)failedExprs.get(i));
                    }
                    throw new AssertionError((Object)rendering);
                }
            }
        }
    };

    public RecorderListener<Boolean> getListener() {
        return this.listener;
    }
}

