/*
 * Decompiled with CFR 0.152.
 */
package org.powerassert.synthetic;

import java.util.ArrayList;
import java.util.List;
import org.powerassert.synthetic.RecordedExpression;
import org.powerassert.synthetic.RecordedValue;
import org.powerassert.synthetic.RecorderListener;
import org.powerassert.synthetic.Recording;

public class RecorderRuntime {
    private RecorderListener<Boolean> listener;
    private List<RecordedExpression<Boolean>> recordedExprs = new ArrayList<RecordedExpression<Boolean>>();
    private List<RecordedValue> recordedValues = new ArrayList<RecordedValue>();

    public RecorderRuntime(RecorderListener<Boolean> listener) {
        this.listener = listener;
    }

    public void resetValues() {
        this.recordedValues = new ArrayList<RecordedValue>();
    }

    public <U> U recordValue(U value, int anchor) {
        RecordedValue recordedValue = new RecordedValue(value, anchor);
        this.listener.valueRecorded(recordedValue);
        this.recordedValues.add(recordedValue);
        return value;
    }

    public void recordExpression(String text, Boolean value, int anchor) {
        for (RecordedValue recordedValue : this.recordedValues) {
            recordedValue.relativizeAnchor(anchor);
        }
        RecordedExpression<Boolean> recordedExpr = new RecordedExpression<Boolean>(text, value, this.recordedValues);
        this.listener.expressionRecorded(recordedExpr);
        this.recordedExprs.add(recordedExpr);
    }

    public Boolean completeRecording() {
        RecordedExpression<Boolean> lastRecorded = this.recordedExprs.get(0);
        Recording<Boolean> recording = new Recording<Boolean>(lastRecorded.getValue(), this.recordedExprs);
        this.listener.recordingCompleted(recording);
        return recording.getValue();
    }
}

