/*
 * Decompiled with CFR 0.152.
 */
package kamon.system;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import akka.actor.ExtensionId;
import akka.actor.Props;
import akka.actor.Scheduler;
import akka.actor.SupervisorStrategy;
import kamon.Kamon$;
import kamon.metric.MetricGroupIdentity;
import kamon.metric.Metrics$;
import kamon.metric.MetricsExtension;
import kamon.metrics.CPUMetrics;
import kamon.metrics.CPUMetrics$;
import kamon.metrics.MemoryMetrics;
import kamon.metrics.MemoryMetrics$;
import kamon.metrics.NetworkMetrics;
import kamon.metrics.NetworkMetrics$;
import kamon.metrics.ProcessCPUMetrics;
import kamon.metrics.ProcessCPUMetrics$;
import kamon.system.SigarExtensionProvider;
import kamon.system.SigarExtensionProvider$class;
import kamon.system.SystemMetricsCollector$;
import kamon.system.SystemMetricsCollector$Collect$;
import kamon.system.SystemMetricsExtension$;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Swap;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tub\u0001B\u0001\u0003\u0001\u001d\u0011acU=ti\u0016lW*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN\u001d\u0006\u0003\u0007\u0011\taa]=ti\u0016l'\"A\u0003\u0002\u000b-\fWn\u001c8\u0004\u0001M!\u0001\u0001\u0003\b\u0017!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002F\u0007\u0002!)\u0011\u0011CE\u0001\u0006C\u000e$xN\u001d\u0006\u0002'\u0005!\u0011m[6b\u0013\t)\u0002CA\u0003BGR|'\u000f\u0005\u0002\u001815\t!!\u0003\u0002\u001a\u0005\t12+[4be\u0016CH/\u001a8tS>t\u0007K]8wS\u0012,'\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003=\u0019w\u000e\u001c7fGRLe\u000e^3sm\u0006d\u0007CA\u000f#\u001b\u0005q\"BA\u0010!\u0003!!WO]1uS>t'BA\u0011\u000b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003Gy\u0011aBR5oSR,G)\u001e:bi&|g\u000eC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0003O!\u0002\"a\u0006\u0001\t\u000bm!\u0003\u0019\u0001\u000f\t\u000f)\u0002!\u0019!C\u0001W\u0005y1m\u001c7mK\u000e$8k\u00195fIVdW-F\u0001-!\tyQ&\u0003\u0002/!\tY1)\u00198dK2d\u0017M\u00197f\u0011\u0019\u0001\u0004\u0001)A\u0005Y\u0005\u00012m\u001c7mK\u000e$8k\u00195fIVdW\r\t\u0005\be\u0001\u0011\r\u0011\"\u00014\u0003Y\u0019\u0018p\u001d;f[6+GO]5dg\u0016CH/\u001a8tS>tW#\u0001\u001b\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\"\u0011AB7fiJL7-\u0003\u0002:m\t\u0001R*\u001a;sS\u000e\u001cX\t\u001f;f]NLwN\u001c\u0005\u0007w\u0001\u0001\u000b\u0011\u0002\u001b\u0002/ML8\u000f^3n\u001b\u0016$(/[2t\u000bb$XM\\:j_:\u0004\u0003bB\u001f\u0001\u0005\u0004%\tAP\u0001\fGB,(+Z2pe\u0012,'/F\u0001@!\rI\u0001IQ\u0005\u0003\u0003*\u0011aa\u00149uS>t\u0007CA\"N\u001d\t!%J\u0004\u0002F\u00116\taI\u0003\u0002H\t\u00059Q.\u001a;sS\u000e\u001c\u0018BA%G\u0003)\u0019\u0005+V'fiJL7m]\u0005\u0003\u00172\u000bqAR1di>\u0014\u0018P\u0003\u0002J\r\u0016!aj\u0014\u0001X\u000559%o\\;q%\u0016\u001cwN\u001d3fe\u001a!\u0001\u000b\u0001\u0001T\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0013\t\u0011F*\u0001\u0005GC\u000e$xN]=!%\ry\u0005\u0002\u0016\t\u0003kUK!A\u0016\u001c\u0003%5+GO]5d\u000fJ|W\u000f\u001d$bGR|'/\u001f\t\u0003\tbK!!\u0017'\u0003#\r\u0003V+T3ue&\u001c'+Z2pe\u0012,'\u000f\u0003\u0004\\\u0001\u0001\u0006IaP\u0001\rGB,(+Z2pe\u0012,'\u000f\t\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0003I\u0001(o\\2fgN\u001c\u0005/\u001e*fG>\u0014H-\u001a:\u0016\u0003}\u00032!\u0003!a!\t\twM\u0004\u0002cK:\u0011QiY\u0005\u0003I\u001a\u000b\u0011\u0003\u0015:pG\u0016\u001c8o\u0011)V\u001b\u0016$(/[2t\u0013\tYeM\u0003\u0002e\r\u0016!a\n\u001b\u0001l\r\u0011\u0001\u0006\u0001\u00016\n\u0005I3'c\u00015\t)B\u0011!\r\\\u0005\u0003[\u001a\u0014\u0011\u0004\u0015:pG\u0016\u001c8o\u0011)V\u001b\u0016$(/[2t%\u0016\u001cwN\u001d3fe\"1q\u000e\u0001Q\u0001\n}\u000b1\u0003\u001d:pG\u0016\u001c8o\u00119v%\u0016\u001cwN\u001d3fe\u0002Bq!\u001d\u0001C\u0002\u0013\u0005!/\u0001\bnK6|'/\u001f*fG>\u0014H-\u001a:\u0016\u0003M\u00042!\u0003!u!\t)8P\u0004\u0002ws:\u0011Qi^\u0005\u0003q\u001a\u000bQ\"T3n_JLX*\u001a;sS\u000e\u001c\u0018BA&{\u0015\tAh)\u0002\u0003Oy\u0002yh\u0001\u0002)\u0001\u0001yL!A\u0015>\u0013\u0007qDA\u000bE\u0002w\u0003\u0003I1!a\u0001{\u0005QiU-\\8ss6+GO]5d%\u0016\u001cwN\u001d3fe\"9\u0011q\u0001\u0001!\u0002\u0013\u0019\u0018aD7f[>\u0014\u0018PU3d_J$WM\u001d\u0011\t\u0013\u0005-\u0001A1A\u0005\u0002\u00055\u0011a\u00048fi^|'o\u001b*fG>\u0014H-\u001a:\u0016\u0005\u0005=\u0001\u0003B\u0005A\u0003#\u0001B!a\u0005\u0002 9!\u0011QCA\u000e\u001d\r)\u0015qC\u0005\u0004\u000331\u0015A\u0004(fi^|'o['fiJL7m]\u0005\u0004\u0017\u0006u!bAA\r\r\u00161a*!\t\u0001\u0003O1Q\u0001\u0015\u0001\u0001\u0003KI1AUA\u000f%\u0011\t\t\u0003\u0003+\u0011\t\u0005U\u0011\u0011F\u0005\u0005\u0003W\tiBA\u000bOKR<xN]6NKR\u0014\u0018n\u0019*fG>\u0014H-\u001a:\t\u0011\u0005=\u0002\u0001)A\u0005\u0003\u001f\t\u0001C\\3uo>\u00148NU3d_J$WM\u001d\u0011\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u00059!/Z2fSZ,WCAA\u001c!\u0011\tI$a\u000f\u000e\u0003\u0001I1!!\u0010\u0015\u0005\u001d\u0011VmY3jm\u0016Dq!!\u0011\u0001\t\u0003\n\u0019%\u0001\u0005q_N$8\u000b^8q)\t\t)\u0005E\u0002\n\u0003\u000fJ1!!\u0013\u000b\u0005\u0011)f.\u001b;\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005q1m\u001c7mK\u000e$X*\u001a;sS\u000e\u001cHCAA)!\u0011I\u0001)!\u0012\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005I!/Z2pe\u0012\u001c\u0005/\u001e\u000b\u0005\u0003\u000b\nI\u0006\u0003\u0005\u0002\\\u0005M\u0003\u0019AA/\u0003\u0011\u0019\u0007/\u001e:\u0011\u0007\u0005}\u0003LD\u0002\u0002b!sA!a\u0019\u0002n9!\u0011QMA6\u001b\t\t9GC\u0002\u0002j\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u0003\n\u0005\u001d#\u0001bBA9\u0001\u0011%\u00111O\u0001\u0011e\u0016\u001cwN\u001d3Qe>\u001cWm]:DaV$B!!\u0012\u0002v!A\u0011qOA8\u0001\u0004\tI(A\u0003qGB,(\u000fE\u0002\u0002|1t1!!\u0019d\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003\u000bAB]3d_J$W*Z7pef$B!!\u0012\u0002\u0004\"A\u0011QQA?\u0001\u0004\t9)\u0001\u0002neB!\u0011\u0011RA\u0001\u001d\r\t\tg\u001e\u0005\b\u0003\u001b\u0003A\u0011BAH\u00035\u0011XmY8sI:+Go^8sWR!\u0011QIAI\u0011!\t\u0019*a#A\u0002\u0005U\u0015A\u00018s!\u0011\t9*!\u000b\u000f\t\u0005\u0005\u0014qC\u0004\b\u00037\u0013\u0001\u0012AAO\u0003Y\u0019\u0016p\u001d;f[6+GO]5dg\u000e{G\u000e\\3di>\u0014\bcA\f\u0002 \u001a1\u0011A\u0001E\u0001\u0003C\u001b2!a(\t\u0011\u001d)\u0013q\u0014C\u0001\u0003K#\"!!(\b\u0011\u0005%\u0016q\u0014EA\u0003W\u000bqaQ8mY\u0016\u001cG\u000f\u0005\u0003\u0002.\u0006=VBAAP\r!\t\t,a(\t\u0002\u0006M&aB\"pY2,7\r^\n\b\u0003_C\u0011QWA^!\rI\u0011qW\u0005\u0004\u0003sS!a\u0002)s_\u0012,8\r\u001e\t\u0004\u0013\u0005u\u0016bAA`\u0015\ta1+\u001a:jC2L'0\u00192mK\"9Q%a,\u0005\u0002\u0005\rGCAAV\u0011)\t9-a,\u0002\u0002\u0013\u0005\u0013\u0011Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\u0007\u0003BAg\u0003/l!!a4\u000b\t\u0005E\u00171[\u0001\u0005Y\u0006twM\u0003\u0002\u0002V\u0006!!.\u0019<b\u0013\u0011\tI.a4\u0003\rM#(/\u001b8h\u0011)\ti.a,\u0002\u0002\u0013\u0005\u0011q\\\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00042!CAr\u0013\r\t)O\u0003\u0002\u0004\u0013:$\bBCAu\u0003_\u000b\t\u0011\"\u0001\u0002l\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAw\u0003g\u00042!CAx\u0013\r\t\tP\u0003\u0002\u0004\u0003:L\bBCA{\u0003O\f\t\u00111\u0001\u0002b\u0006\u0019\u0001\u0010J\u0019\t\u0015\u0005e\u0018qVA\u0001\n\u0003\nY0A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0010\u0005\u0004\u0002\u0000\n\u0015\u0011Q^\u0007\u0003\u0005\u0003Q1Aa\u0001\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011Y!a,\u0002\u0002\u0013\u0005!QB\u0001\tG\u0006tW)];bYR!!q\u0002B\u000b!\rI!\u0011C\u0005\u0004\u0005'Q!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003k\u0014I!!AA\u0002\u00055\bB\u0003B\r\u0003_\u000b\t\u0011\"\u0011\u0003\u001c\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002b\"Q!qDAX\u0003\u0003%\tE!\t\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a3\t\u0015\t\u0015\u0012qVA\u0001\n\u0013\u00119#A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\u0015!\u0011\tiMa\u000b\n\t\t5\u0012q\u001a\u0002\u0007\u001f\nTWm\u0019;\t\u0011\tE\u0012q\u0014C\u0001\u0005g\tQ\u0001\u001d:paN$BA!\u000e\u0003<A\u0019qBa\u000e\n\u0007\te\u0002CA\u0003Qe>\u00048\u000f\u0003\u0004\u001c\u0005_\u0001\r\u0001\b")
public class SystemMetricsCollector
implements Actor,
SigarExtensionProvider {
    private final Cancellable collectSchedule;
    private final MetricsExtension systemMetricsExtension;
    private final Option<CPUMetrics.CPUMetricRecorder> cpuRecorder;
    private final Option<ProcessCPUMetrics.ProcessCPUMetricsRecorder> processCpuRecorder;
    private final Option<MemoryMetrics.MemoryMetricRecorder> memoryRecorder;
    private final Option<NetworkMetrics.NetworkMetricRecorder> networkRecorder;
    private final SigarProxy sigar;
    private final Set<String> interfaces;
    private final ActorContext context;
    private final ActorRef self;
    private volatile boolean bitmap$0;

    public static Props props(FiniteDuration finiteDuration) {
        return SystemMetricsCollector$.MODULE$.props(finiteDuration);
    }

    private SigarProxy sigar$lzycompute() {
        SystemMetricsCollector systemMetricsCollector = this;
        synchronized (systemMetricsCollector) {
            if (!this.bitmap$0) {
                this.sigar = SigarExtensionProvider$class.sigar(this);
                this.bitmap$0 = true;
            }
            return this.sigar;
        }
    }

    @Override
    public SigarProxy sigar() {
        return this.bitmap$0 ? this.sigar : this.sigar$lzycompute();
    }

    @Override
    public Set<String> interfaces() {
        return this.interfaces;
    }

    @Override
    public void kamon$system$SigarExtensionProvider$_setter_$interfaces_$eq(Set x$1) {
        this.interfaces = x$1;
    }

    @Override
    public long pid() {
        return SigarExtensionProvider$class.pid(this);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
    }

    public void aroundPreStart() {
        Actor.class.aroundPreStart((Actor)this);
    }

    public void aroundPostStop() {
        Actor.class.aroundPostStop((Actor)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void preStart() throws Exception {
        Actor.class.preStart((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public Cancellable collectSchedule() {
        return this.collectSchedule;
    }

    public MetricsExtension systemMetricsExtension() {
        return this.systemMetricsExtension;
    }

    public Option<CPUMetrics.CPUMetricRecorder> cpuRecorder() {
        return this.cpuRecorder;
    }

    public Option<ProcessCPUMetrics.ProcessCPUMetricsRecorder> processCpuRecorder() {
        return this.processCpuRecorder;
    }

    public Option<MemoryMetrics.MemoryMetricRecorder> memoryRecorder() {
        return this.memoryRecorder;
    }

    public Option<NetworkMetrics.NetworkMetricRecorder> networkRecorder() {
        return this.networkRecorder;
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ SystemMetricsCollector $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (SystemMetricsCollector$Collect$.MODULE$.equals(A1)) {
                    this.$outer.collectMetrics();
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = SystemMetricsCollector$Collect$.MODULE$.equals(object);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public void postStop() {
        this.collectSchedule().cancel();
    }

    public Option<BoxedUnit> collectMetrics() {
        this.cpuRecorder().map((Function1)new Serializable(this){
            private final /* synthetic */ SystemMetricsCollector $outer;

            public final void apply(CPUMetrics.CPUMetricRecorder cpur) {
                this.$outer.kamon$system$SystemMetricsCollector$$recordCpu(cpur);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.processCpuRecorder().map((Function1)new Serializable(this){
            private final /* synthetic */ SystemMetricsCollector $outer;

            public final void apply(ProcessCPUMetrics.ProcessCPUMetricsRecorder pcpur) {
                this.$outer.kamon$system$SystemMetricsCollector$$recordProcessCpu(pcpur);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.memoryRecorder().map((Function1)new Serializable(this){
            private final /* synthetic */ SystemMetricsCollector $outer;

            public final void apply(MemoryMetrics.MemoryMetricRecorder mr) {
                this.$outer.kamon$system$SystemMetricsCollector$$recordMemory(mr);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.networkRecorder().map((Function1)new Serializable(this){
            private final /* synthetic */ SystemMetricsCollector $outer;

            public final void apply(NetworkMetrics.NetworkMetricRecorder nr) {
                this.$outer.kamon$system$SystemMetricsCollector$$recordNetwork(nr);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void kamon$system$SystemMetricsCollector$$recordCpu(CPUMetrics.CPUMetricRecorder cpur) {
        CpuPerc cpuPerc = this.sigar().getCpuPerc();
        cpur.user().record(SystemMetricsExtension$.MODULE$.toLong(cpuPerc.getUser()));
        cpur.system().record(SystemMetricsExtension$.MODULE$.toLong(cpuPerc.getSys()));
        cpur.cpuWait().record(SystemMetricsExtension$.MODULE$.toLong(cpuPerc.getWait()));
        cpur.idle().record(SystemMetricsExtension$.MODULE$.toLong(cpuPerc.getIdle()));
    }

    public void kamon$system$SystemMetricsCollector$$recordProcessCpu(ProcessCPUMetrics.ProcessCPUMetricsRecorder pcpur) {
        ProcCpu procCpu = this.sigar().getProcCpu(this.pid());
        pcpur.user().record(procCpu.getUser());
        pcpur.system().record(procCpu.getSys());
    }

    public void kamon$system$SystemMetricsCollector$$recordMemory(MemoryMetrics.MemoryMetricRecorder mr) {
        Mem mem = this.sigar().getMem();
        Swap swap = this.sigar().getSwap();
        mr.used().record(SystemMetricsExtension$.MODULE$.toMB(mem.getUsed()));
        mr.free().record(SystemMetricsExtension$.MODULE$.toMB(mem.getFree()));
        mr.swapUsed().record(SystemMetricsExtension$.MODULE$.toMB(swap.getUsed()));
        mr.swapFree().record(SystemMetricsExtension$.MODULE$.toMB(swap.getFree()));
        mr.buffer().record(SystemMetricsExtension$.MODULE$.toMB(this.collectBuffer$1(mem)));
        mr.cache().record(SystemMetricsExtension$.MODULE$.toMB(this.collectCache$1(mem)));
    }

    public void kamon$system$SystemMetricsCollector$$recordNetwork(NetworkMetrics.NetworkMetricRecorder nr) {
        nr.rxBytes().record(this.collect$1(this.sigar(), this.interfaces(), (Function1)new Serializable(this){

            public final long apply(NetInterfaceStat net) {
                return SystemMetricsExtension$.MODULE$.toKB(net.getRxBytes());
            }
        }));
        nr.txBytes().record(this.collect$1(this.sigar(), this.interfaces(), (Function1)new Serializable(this){

            public final long apply(NetInterfaceStat net) {
                return SystemMetricsExtension$.MODULE$.toKB(net.getTxBytes());
            }
        }));
        nr.rxErrors().record(this.collect$1(this.sigar(), this.interfaces(), (Function1)new Serializable(this){

            public final long apply(NetInterfaceStat net) {
                return net.getRxErrors();
            }
        }));
        nr.txErrors().record(this.collect$1(this.sigar(), this.interfaces(), (Function1)new Serializable(this){

            public final long apply(NetInterfaceStat net) {
                return net.getTxErrors();
            }
        }));
    }

    private final long collectBuffer$1(Mem mem) {
        return mem.getUsed() != mem.getActualUsed() ? mem.getActualUsed() : 0L;
    }

    private final long collectCache$1(Mem mem) {
        return mem.getFree() != mem.getActualFree() ? mem.getActualFree() : 0L;
    }

    private final long collect$1(SigarProxy sigar, Set interfaces, Function1 block) {
        return BoxesRunTime.unboxToLong((Object)interfaces.foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this, sigar, block){
            private final SigarProxy sigar$1;
            private final Function1 block$1;

            public final long apply(long totalBytes, String string) {
                NetInterfaceStat net = this.sigar$1.getNetInterfaceStat(string);
                return totalBytes + BoxesRunTime.unboxToLong((Object)this.block$1.apply((Object)net));
            }
            {
                this.sigar$1 = sigar$1;
                this.block$1 = block$1;
            }
        }));
    }

    public SystemMetricsCollector(FiniteDuration collectInterval) {
        Actor.class.$init$((Actor)this);
        SigarExtensionProvider$class.$init$(this);
        Scheduler qual$1 = this.context().system().scheduler();
        FiniteDuration x$1 = collectInterval;
        FiniteDuration x$2 = collectInterval;
        ActorRef x$3 = this.self();
        SystemMetricsCollector$Collect$ x$4 = SystemMetricsCollector$Collect$.MODULE$;
        ExecutionContextExecutor x$5 = this.context().dispatcher();
        ActorRef x$6 = qual$1.schedule$default$6(x$1, x$2, x$3, (Object)x$4);
        this.collectSchedule = qual$1.schedule(x$1, x$2, x$3, (Object)x$4, (ExecutionContext)x$5, x$6);
        this.systemMetricsExtension = (MetricsExtension)Kamon$.MODULE$.apply((ExtensionId)Metrics$.MODULE$, this.context().system());
        this.cpuRecorder = this.systemMetricsExtension().register((MetricGroupIdentity)new CPUMetrics(SystemMetricsExtension$.MODULE$.CPU()), CPUMetrics$.MODULE$.Factory());
        this.processCpuRecorder = this.systemMetricsExtension().register((MetricGroupIdentity)new ProcessCPUMetrics(SystemMetricsExtension$.MODULE$.ProcessCPU()), ProcessCPUMetrics$.MODULE$.Factory());
        this.memoryRecorder = this.systemMetricsExtension().register((MetricGroupIdentity)new MemoryMetrics(SystemMetricsExtension$.MODULE$.Memory()), MemoryMetrics$.MODULE$.Factory());
        this.networkRecorder = this.systemMetricsExtension().register((MetricGroupIdentity)new NetworkMetrics(SystemMetricsExtension$.MODULE$.Network()), NetworkMetrics$.MODULE$.Factory());
    }
}

