/*
 * Decompiled with CFR 0.152.
 */
package kamon.system.sigar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import kamon.system.sigar.SigarLoader;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Uptime;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

public final class SigarLoader$ {
    public static final SigarLoader$ MODULE$;
    private final String Version;
    private final String JavaLibraryPath;
    private final String TmpDir;
    private final String IndexFile;
    private final String UsrPathField;
    private final Logger log;
    private final Field usrPathField;

    static {
        new SigarLoader$();
    }

    public String Version() {
        return this.Version;
    }

    public String JavaLibraryPath() {
        return this.JavaLibraryPath;
    }

    public String TmpDir() {
        return this.TmpDir;
    }

    public String IndexFile() {
        return this.IndexFile;
    }

    public String UsrPathField() {
        return this.UsrPathField;
    }

    private Logger log() {
        return this.log;
    }

    public SigarProxy sigarProxy() {
        return this.init(new File(System.getProperty(this.TmpDir())));
    }

    public SigarProxy init(File baseTmp) {
        File tmpDir = this.createTmpDir(baseTmp);
        JavaConversions$.MODULE$.asScalaBuffer(this.loadIndex()).foreach((Function1)new Serializable(tmpDir){
            private final File tmpDir$1;

            public final void apply(String lib) {
                SigarLoader$.MODULE$.copy(lib, this.tmpDir$1);
            }
            {
                this.tmpDir$1 = tmpDir$1;
            }
        });
        this.attachToLibraryPath(tmpDir);
        try {
            Sigar sigar = new Sigar();
            this.printBanner(sigar);
            return sigar;
        }
        catch (Throwable throwable) {
            this.log().severe("Failed to load sigar");
            throw new RuntimeException(throwable);
        }
    }

    public Field usrPathField() {
        return this.usrPathField;
    }

    public void attachToLibraryPath(File dir) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            Object object = new Object();
            try {
                String dirAbsolute = dir.getAbsolutePath();
                System.setProperty(this.JavaLibraryPath(), this.newLibraryPath(dirAbsolute));
                String[] paths = (String[])this.usrPathField().get(null);
                if (paths == null) {
                    paths = new String[]{};
                }
                Predef$.MODULE$.refArrayOps((Object[])paths).foreach((Function1)new Serializable(dirAbsolute, object){
                    private final String dirAbsolute$1;
                    private final Object nonLocalReturnKey1$1;

                    public final void apply(String path) {
                        String string = path;
                        String string2 = this.dirAbsolute$1;
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                        }
                    }
                    {
                        this.dirAbsolute$1 = dirAbsolute$1;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                });
                String[] newPaths = (String[])Arrays.copyOf((Object[])paths, paths.length + 1);
                newPaths[newPaths.length - 1] = dirAbsolute;
                this.usrPathField().set(null, newPaths);
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                nonLocalReturnControl2.value$mcV$sp();
            }
            return;
        }
        throw nonLocalReturnControl2;
    }

    public String newLibraryPath(String dirAbsolutePath) {
        return (String)Option$.MODULE$.apply((Object)System.getProperty(this.JavaLibraryPath())).fold((Function0)new Serializable(dirAbsolutePath){
            private final String dirAbsolutePath$1;

            public final String apply() {
                return this.dirAbsolutePath$1;
            }
            {
                this.dirAbsolutePath$1 = dirAbsolutePath$1;
            }
        }, (Function1)new Serializable(dirAbsolutePath){
            private final String dirAbsolutePath$1;

            public final String apply(String oldValue) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dirAbsolutePath$1, File.pathSeparator, oldValue}));
            }
            {
                this.dirAbsolutePath$1 = dirAbsolutePath$1;
            }
        });
    }

    public void copy(String lib, File tmpDir) {
        File target = new File(tmpDir, lib);
        if (target.exists()) {
            return;
        }
        this.write(SigarLoader.Loader.class.getResourceAsStream(lib), target);
    }

    /*
     * WARNING - void declaration
     */
    public File createTmpDir(File baseTmp) {
        void var2_2;
        File tmpDir = new File(baseTmp, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sigar-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.Version()})));
        if (tmpDir.exists() || tmpDir.mkdirs()) {
            if (tmpDir.isDirectory()) {
                if (tmpDir.canWrite()) {
                    return var2_2;
                }
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sigar temp directory not writeable: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2.getAbsolutePath()})));
            }
            throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sigar temp directory path is not a directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2.getAbsolutePath()})));
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not create temp sigar directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2.getAbsolutePath()})));
    }

    /*
     * WARNING - void declaration
     */
    public List<String> loadIndex() {
        void var1_1;
        ArrayList libs = new ArrayList();
        InputStream is = SigarLoader.Loader.class.getResourceAsStream(this.IndexFile());
        Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(libs){
            private final ArrayList libs$1;

            public final boolean apply(String line) {
                String currentLine = line.trim();
                return this.libs$1.add(currentLine);
            }
            {
                this.libs$1 = libs$1;
            }
        });
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void write(InputStream input, File to) {
        FileOutputStream out = new FileOutputStream(to);
        try {
            this.transfer(input, out);
        }
        catch (Throwable throwable) {
            void var3_3;
            var3_3.close();
            throw throwable;
        }
        out.close();
    }

    public void transfer(InputStream input, OutputStream out) {
        byte[] buffer = new byte[8192];
        this.transfer$1(input, out, buffer);
    }

    public void printBanner(Sigar sigar) {
        OperatingSystem os = OperatingSystem.getInstance();
        String message = new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("\n        |\n        |  _____           _                 __  __      _        _          _                     _          _\n        | / ____|         | |               |  \\/  |    | |      (_)        | |                   | |        | |\n        || (___  _   _ ___| |_ ___ _ __ ___ | \\  / | ___| |_ _ __ _  ___ ___| |     ___   __ _  __| | ___  __| |\n        | \\___ \\| | | / __| __/ _ \\ '_ ` _ \\| |\\/| |/ _ \\ __| '__| |/ __/ __| |    / _ \\ / _` |/ _` |/ _ \\/ _` |\n        | ____) | |_| \\__ \\ ||  __/ | | | | | |  | |  __/ |_| |  | | (__\\__ \\ |___| (_) | (_| | (_| |  __/ (_| |\n        ||_____/ \\__, |___/\\__\\___|_| |_| |_|_|  |_|\\___|\\__|_|  |_|\\___|___/______\\___/ \\__,_|\\__,_|\\___|\\__,_|\n        |         __/ |\n        |        |___/\n        |\n        |              [System Status]                                                    [OS Information]\n        |     |--------------------------------|                             |----------------------------------------|\n        |          Boot Time: %-10s                                           Description: %s\n        |       Load Average: %-16s                                            Name: %s\n        |                                                                              Version: %s\n        |                                                                                 Arch: %s\n        |\n      ")).stripMargin())).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uptime$1(sigar), os.getDescription(), this.loadAverage$1(sigar), os.getName(), os.getVersion(), os.getArch()}));
        this.log().info(message);
    }

    private final void transfer$1(InputStream input$1, OutputStream out$1, byte[] buffer$1) {
        int read;
        while ((read = input$1.read(buffer$1)) >= 0) {
            out$1.write(buffer$1, 0, read);
        }
    }

    private final Tuple3 loadAverage$1(Sigar sigar) {
        double[] average = sigar.getLoadAverage();
        return new Tuple3((Object)BoxesRunTime.boxToDouble((double)average[0]), (Object)BoxesRunTime.boxToDouble((double)average[1]), (Object)BoxesRunTime.boxToDouble((double)average[2]));
    }

    private final String uptime$1(Sigar sigar) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Uptime uptime = sigar.getUptime();
        long now = System.currentTimeMillis();
        return sdf.format(new Date(now - (long)(uptime.getUptime() * (double)1000)));
    }

    /*
     * WARNING - void declaration
     */
    private SigarLoader$() {
        void var1_1;
        MODULE$ = this;
        this.Version = "1.6.4";
        this.JavaLibraryPath = "java.library.path";
        this.TmpDir = "java.io.tmpdir";
        this.IndexFile = "/kamon/system/sigar/index";
        this.UsrPathField = "usr_paths";
        this.log = Logger.getLogger("SigarLoader");
        Field usrPathField = ClassLoader.class.getDeclaredField(this.UsrPathField());
        usrPathField.setAccessible(true);
        this.usrPathField = var1_1;
    }
}

