/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.bootstrap;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.kroxylicious.proxy.config.FilterDefinition;
import io.kroxylicious.proxy.config.PluginFactory;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.filter.Filter;
import io.kroxylicious.proxy.filter.FilterAndInvoker;
import io.kroxylicious.proxy.filter.FilterDispatchExecutor;
import io.kroxylicious.proxy.filter.FilterFactory;
import io.kroxylicious.proxy.filter.FilterFactoryContext;
import io.kroxylicious.proxy.plugin.PluginConfigurationException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class FilterChainFactory
implements AutoCloseable {
    private final List<Wrapper> initialized;

    public FilterChainFactory(final PluginFactoryRegistry pfr, List<FilterDefinition> filterDefinitions) {
        Class<FilterFactory> type = FilterFactory.class;
        PluginFactory<FilterFactory> pluginFactory = pfr.pluginFactory(type);
        if (filterDefinitions == null || filterDefinitions.isEmpty()) {
            this.initialized = List.of();
        } else {
            FilterFactoryContext context = new FilterFactoryContext(){

                public ScheduledExecutorService eventLoop() {
                    return null;
                }

                public FilterDispatchExecutor filterDispatchExecutor() {
                    throw new IllegalStateException("no Filter Dispatch executor available at filter factory initialization time");
                }

                @NonNull
                public <P> P pluginInstance(@NonNull Class<P> pluginClass, @NonNull String instanceName) {
                    return pfr.pluginFactory(pluginClass).pluginInstance(instanceName);
                }
            };
            this.initialized = new ArrayList<Wrapper>(filterDefinitions.size());
            try {
                for (FilterDefinition fd : filterDefinitions) {
                    FilterFactory filterFactory = pluginFactory.pluginInstance(fd.type());
                    Class<?> configType = pluginFactory.configType(fd.type());
                    if (fd.config() == null || configType.isInstance(fd.config())) {
                        Wrapper uninitializedFilterFactory = new Wrapper(context, fd.type(), (FilterFactory<? super Object, ? super Object>)filterFactory, fd.config());
                        this.initialized.add(uninitializedFilterFactory);
                        continue;
                    }
                    throw new PluginConfigurationException("accepts config of type " + configType.getName() + " but provided with config of type " + fd.config().getClass().getName() + "]");
                }
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        }
    }

    @Override
    public void close() {
        RuntimeException firstThrown = null;
        for (int i = this.initialized.size() - 1; i >= 0; --i) {
            Wrapper wrapper = this.initialized.get(i);
            try {
                wrapper.close();
                continue;
            }
            catch (RuntimeException e) {
                if (firstThrown == null) {
                    firstThrown = e;
                    continue;
                }
                firstThrown.addSuppressed(e);
            }
        }
        if (firstThrown != null) {
            throw firstThrown;
        }
    }

    public List<FilterAndInvoker> createFilters(FilterFactoryContext context) {
        return this.initialized.stream().flatMap(wrapper -> FilterAndInvoker.build(wrapper.create(context)).stream()).toList();
    }

    private static final class Wrapper
    implements AutoCloseable {
        private final FilterFactory<? super Object, ? super Object> filterFactory;
        private final Object config;
        private final Object initResult;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private Wrapper(FilterFactoryContext context, String instanceName, FilterFactory<? super Object, ? super Object> filterFactory, Object config) {
            this.filterFactory = filterFactory;
            this.config = config;
            try {
                this.initResult = filterFactory.initialize(context, config);
            }
            catch (Exception e) {
                throw new PluginConfigurationException("Exception initializing filter factory " + instanceName + " with config " + String.valueOf(config) + ": " + e.getMessage(), (Throwable)e);
            }
        }

        public Filter create(FilterFactoryContext context) {
            if (this.closed.get()) {
                throw new IllegalStateException("Filter factory is closed");
            }
            try {
                return this.filterFactory.createFilter(context, this.initResult);
            }
            catch (Exception e) {
                throw new PluginConfigurationException("Exception instantiating filter using factory " + String.valueOf(this.filterFactory), (Throwable)e);
            }
        }

        @Override
        public void close() {
            if (!this.closed.getAndSet(true)) {
                this.filterFactory.close(this.initResult);
            }
        }

        public String toString() {
            return "Wrapper[filterFactory=" + String.valueOf(this.filterFactory) + ", config=" + String.valueOf(this.config) + "]";
        }
    }
}

