/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.kroxylicious.proxy.config.ConfigParser;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractDefinitionBuilder<D> {
    protected static final ObjectMapper mapper = ConfigParser.createObjectMapper();
    private final String type;
    private Map<String, Object> config;

    protected AbstractDefinitionBuilder(String type) {
        Objects.requireNonNull(type);
        this.type = type;
    }

    public AbstractDefinitionBuilder<D> withConfig(Map<String, Object> config) {
        Objects.requireNonNull(config);
        if (this.config == null) {
            this.config = new LinkedHashMap<String, Object>();
        }
        this.config.putAll(config);
        return this;
    }

    public AbstractDefinitionBuilder<D> withConfig(String k1, Object v1) {
        return this.withConfig(Map.of(k1, v1));
    }

    public AbstractDefinitionBuilder<D> withConfig(String k1, Object v1, String k2, Object v2) {
        return this.withConfig(Map.of(k1, v1, k2, v2));
    }

    public AbstractDefinitionBuilder<D> withConfig(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        return this.withConfig(Map.of(k1, v1, k2, v2, k3, v3));
    }

    public AbstractDefinitionBuilder<D> withConfig(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        return this.withConfig(Map.of(k1, v1, k2, v2, k3, v3, k4, v4));
    }

    public D build() {
        return this.buildInternal(this.type, this.config);
    }

    protected abstract D buildInternal(String var1, Map<String, Object> var2);
}

