/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.kroxylicious.proxy.config.PluginFactory;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.plugin.Plugin;
import io.kroxylicious.proxy.plugin.UnknownPluginInstanceException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBasedPluginFactoryRegistry
implements PluginFactoryRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBasedPluginFactoryRegistry.class);
    private final Map<Class<?>, Map<String, ProviderAndConfigType>> pluginInterfaceToNameToProvider = new ConcurrentHashMap();

    @NonNull
    Map<String, ProviderAndConfigType> load(@NonNull Class<?> pluginInterface) {
        Objects.requireNonNull(pluginInterface);
        return this.pluginInterfaceToNameToProvider.computeIfAbsent(pluginInterface, i -> ServiceBasedPluginFactoryRegistry.loadProviders(pluginInterface));
    }

    private static Map<String, ProviderAndConfigType> loadProviders(Class<?> pluginInterface) {
        HashMap nameToProviders = new HashMap();
        ServiceLoader<?> load = ServiceLoader.load(pluginInterface);
        load.stream().forEach(provider -> {
            Class providerType = provider.type();
            Plugin annotation = providerType.getAnnotation(Plugin.class);
            if (annotation == null) {
                LOGGER.warn("Failed to find a @PluginConfigType on provider {} of service {}", providerType, (Object)pluginInterface);
            } else {
                ProviderAndConfigType providerAndConfigType = new ProviderAndConfigType((ServiceLoader.Provider<?>)provider, annotation.configType());
                Stream.of(providerType.getName(), providerType.getSimpleName()).forEach(name2 -> nameToProviders.compute(name2, (k2, v) -> {
                    if (v == null) {
                        v = new HashSet<ProviderAndConfigType>();
                    }
                    v.add(providerAndConfigType);
                    return v;
                }));
            }
        });
        Map<Boolean, List<Map.Entry>> bySingleton = nameToProviders.entrySet().stream().collect(Collectors.partitioningBy(e -> ((Set)e.getValue()).size() == 1));
        if (LOGGER.isWarnEnabled()) {
            for (Map.Entry ambiguousInstanceNameToProviders : bySingleton.get(false)) {
                LOGGER.warn("'{}' would be an ambiguous reference to a {} provider. It could refer to any of {} so to avoid ambiguous behaviour those fully qualified names must be used", new Object[]{ambiguousInstanceNameToProviders.getKey(), pluginInterface.getSimpleName(), ((Set)ambiguousInstanceNameToProviders.getValue()).stream().map(p -> p.provider().type().getName()).collect(Collectors.joining(", "))});
            }
        }
        return bySingleton.get(true).stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (ProviderAndConfigType)((Set)e.getValue()).iterator().next()));
    }

    @Override
    @NonNull
    public <P> PluginFactory<P> pluginFactory(final @NonNull Class<P> pluginClass) {
        final Map<String, ProviderAndConfigType> nameToProvider = this.load(pluginClass);
        return new PluginFactory<P>(){

            @Override
            @NonNull
            public P pluginInstance(@NonNull String instanceName) {
                if (Objects.requireNonNull(instanceName).isEmpty()) {
                    throw new IllegalArgumentException();
                }
                ProviderAndConfigType provider = (ProviderAndConfigType)nameToProvider.get(instanceName);
                if (provider != null) {
                    Class<?> type = provider.provider().type();
                    if (type.isAnnotationPresent(Deprecated.class)) {
                        LOGGER.warn("{} plugin with id {} is deprecated", (Object)pluginClass.getName(), (Object)instanceName);
                    }
                    return pluginClass.cast(provider.provider().get());
                }
                throw this.unknownPluginInstanceException(instanceName);
            }

            private UnknownPluginInstanceException unknownPluginInstanceException(String name) {
                return new UnknownPluginInstanceException("Unknown " + pluginClass.getName() + " plugin instance for name '" + name + "'. Known plugin instances are " + String.valueOf(nameToProvider.keySet()) + ". Plugins must be loadable by java.util.ServiceLoader and annotated with @" + Plugin.class.getSimpleName() + ".");
            }

            @Override
            @NonNull
            public Class<?> configType(@NonNull String instanceName) {
                ProviderAndConfigType providerAndConfigType = (ProviderAndConfigType)nameToProvider.get(instanceName);
                if (providerAndConfigType != null) {
                    return providerAndConfigType.config();
                }
                throw this.unknownPluginInstanceException(instanceName);
            }
        };
    }

    public record ProviderAndConfigType(@NonNull ServiceLoader.Provider<?> provider, @NonNull Class<?> config) {
        public ProviderAndConfigType {
            Objects.requireNonNull(provider);
            Objects.requireNonNull(config);
        }
    }
}

