/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config.tls;

import io.kroxylicious.proxy.config.secret.PasswordProvider;
import io.kroxylicious.proxy.config.tls.KeyPair;
import io.kroxylicious.proxy.config.tls.KeyProvider;
import io.kroxylicious.proxy.config.tls.KeyProviderVisitor;
import io.kroxylicious.proxy.config.tls.KeyStore;
import io.kroxylicious.proxy.config.tls.SslContextBuildException;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;

public class NettyKeyProvider {
    private final KeyProvider delegate;

    public NettyKeyProvider(KeyProvider delegate) {
        this.delegate = delegate;
    }

    public SslContextBuilder forClient() {
        SslContextBuilder client = SslContextBuilder.forClient();
        return this.configureBuilder((arg_0, arg_1, arg_2) -> ((SslContextBuilder)client).keyManager(arg_0, arg_1, arg_2), arg_0 -> ((SslContextBuilder)client).keyManager(arg_0));
    }

    public SslContextBuilder forServer() {
        return this.configureBuilder(SslContextBuilder::forServer, SslContextBuilder::forServer);
    }

    private SslContextBuilder configureBuilder(final SslContextBuilderA a, final SslContextBuilderB b) {
        return (SslContextBuilder)this.delegate.accept((KeyProviderVisitor)new KeyProviderVisitor<SslContextBuilder>(){

            public SslContextBuilder visit(KeyPair keyPair) {
                try {
                    return a.keyManager(new File(keyPair.certificateFile()), new File(keyPair.privateKeyFile()), Optional.ofNullable(keyPair.keyPasswordProvider()).map(PasswordProvider::getProvidedPassword).orElse(null));
                }
                catch (Exception e) {
                    throw new SslContextBuildException("Error building SSLContext for KeyPair: " + String.valueOf(keyPair), e);
                }
            }

            public SslContextBuilder visit(KeyStore keyStore) {
                try {
                    File keyStoreFile = new File(keyStore.storeFile());
                    if (keyStore.isPemType()) {
                        return a.keyManager(keyStoreFile, keyStoreFile, Optional.ofNullable(keyStore.keyPasswordProvider()).map(PasswordProvider::getProvidedPassword).orElse(null));
                    }
                    return b.keyManager(NettyKeyProvider.this.keyManagerFactory(keyStore));
                }
                catch (Exception e) {
                    throw new SslContextBuildException("Error building SSLContext for KeyStore: " + String.valueOf(keyStore), e);
                }
            }
        });
    }

    private KeyManagerFactory keyManagerFactory(KeyStore store) {
        KeyManagerFactory keyManagerFactory;
        FileInputStream is = new FileInputStream(store.storeFile());
        try {
            char[] password = Optional.ofNullable(store.storePasswordProvider()).map(PasswordProvider::getProvidedPassword).map(String::toCharArray).orElse(null);
            java.security.KeyStore keyStore = java.security.KeyStore.getInstance(store.getType());
            keyStore.load(is, password);
            KeyManagerFactory keyManagerFactory2 = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory2.init(keyStore, Optional.ofNullable(store.keyPasswordProvider()).map(PasswordProvider::getProvidedPassword).map(String::toCharArray).orElse(password));
            keyManagerFactory = keyManagerFactory2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Error building SSLContext from : " + store.storeFile(), e);
            }
        }
        is.close();
        return keyManagerFactory;
    }

    static interface SslContextBuilderA {
        public SslContextBuilder keyManager(File var1, File var2, String var3);
    }

    static interface SslContextBuilderB {
        public SslContextBuilder keyManager(KeyManagerFactory var1);
    }
}

