/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config.tls;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.secret.PasswordProvider;
import io.kroxylicious.proxy.config.tls.InsecureTls;
import io.kroxylicious.proxy.config.tls.PlatformTrustProvider;
import io.kroxylicious.proxy.config.tls.SslContextBuildException;
import io.kroxylicious.proxy.config.tls.TrustProvider;
import io.kroxylicious.proxy.config.tls.TrustProviderVisitor;
import io.kroxylicious.proxy.config.tls.TrustStore;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Optional;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class NettyTrustProvider {
    public static final String HTTPS_HOSTNAME_VERIFICATION = "HTTPS";
    private final TrustProvider trustProvider;

    public NettyTrustProvider(TrustProvider trustProvider) {
        this.trustProvider = trustProvider;
    }

    public SslContextBuilder apply(final SslContextBuilder builder) {
        return (SslContextBuilder)this.trustProvider.accept((TrustProviderVisitor)new TrustProviderVisitor<SslContextBuilder>(){

            public SslContextBuilder visit(TrustStore trustStore) {
                SslContextBuilder sslContextBuilder;
                this.enableHostnameVerification();
                if (trustStore.isPemType()) {
                    return builder.trustManager(new File(trustStore.storeFile()));
                }
                FileInputStream is = new FileInputStream(trustStore.storeFile());
                try {
                    char[] password = Optional.ofNullable(trustStore.storePasswordProvider()).map(PasswordProvider::getProvidedPassword).map(String::toCharArray).orElse(null);
                    KeyStore keyStore = KeyStore.getInstance(trustStore.getType());
                    keyStore.load(is, password);
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    sslContextBuilder = builder.trustManager(trustManagerFactory);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new SslContextBuildException("Error building SSLContext for TrustStore: " + String.valueOf(trustStore), e);
                    }
                }
                is.close();
                return sslContextBuilder;
            }

            public SslContextBuilder visit(InsecureTls insecureTls) {
                try {
                    if (insecureTls.insecure()) {
                        this.disableHostnameVerification();
                        return builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                    }
                    this.enableHostnameVerification();
                    return builder;
                }
                catch (Exception e) {
                    throw new SslContextBuildException("Error building SSLContext for InsecureTls: " + String.valueOf(insecureTls), e);
                }
            }

            public SslContextBuilder visit(PlatformTrustProvider platformTrustProviderTls) {
                this.enableHostnameVerification();
                return builder;
            }

            private void enableHostnameVerification() {
                this.setEndpointAlgorithm(NettyTrustProvider.HTTPS_HOSTNAME_VERIFICATION);
            }

            private void disableHostnameVerification() {
                this.setEndpointAlgorithm(null);
            }

            private void setEndpointAlgorithm(@Nullable String httpsHostnameVerification) {
                builder.endpointIdentificationAlgorithm(httpsHostnameVerification);
            }
        });
    }
}

