/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.filter;

import io.kroxylicious.proxy.filter.Filter;
import io.kroxylicious.proxy.filter.FilterAndInvoker;
import io.kroxylicious.proxy.filter.FilterInvoker;
import io.kroxylicious.proxy.filter.HandleNothingFilterInvoker;
import io.kroxylicious.proxy.filter.RequestFilter;
import io.kroxylicious.proxy.filter.RequestFilterInvoker;
import io.kroxylicious.proxy.filter.RequestResponseInvoker;
import io.kroxylicious.proxy.filter.ResponseFilter;
import io.kroxylicious.proxy.filter.ResponseFilterInvoker;
import io.kroxylicious.proxy.filter.SafeInvoker;
import io.kroxylicious.proxy.filter.SpecificFilterArrayInvoker;
import java.util.List;
import java.util.stream.Stream;

public class FilterInvokers {
    private FilterInvokers() {
    }

    static List<FilterAndInvoker> from(Filter filter) {
        List<FilterAndInvoker> filterInvokers = FilterInvokers.invokersForFilter(filter);
        return FilterInvokers.wrapAllInSafeInvoker(filterInvokers).toList();
    }

    private static List<FilterAndInvoker> invokersForFilter(Filter filter) {
        boolean isResponseFilter = filter instanceof ResponseFilter;
        boolean isRequestFilter = filter instanceof RequestFilter;
        boolean isAnySpecificFilterInterface = SpecificFilterArrayInvoker.implementsAnySpecificFilterInterface(filter);
        FilterInvokers.validateFilter(filter, isResponseFilter, isRequestFilter, isAnySpecificFilterInterface);
        if (isResponseFilter && isRequestFilter) {
            return FilterInvokers.singleFilterAndInvoker(filter, new RequestResponseInvoker((RequestFilter)filter, (ResponseFilter)filter));
        }
        if (isRequestFilter) {
            return FilterInvokers.singleFilterAndInvoker(filter, new RequestFilterInvoker((RequestFilter)filter));
        }
        if (isResponseFilter) {
            return FilterInvokers.singleFilterAndInvoker(filter, new ResponseFilterInvoker((ResponseFilter)filter));
        }
        return FilterInvokers.singleFilterAndInvoker(filter, FilterInvokers.arrayInvoker(filter));
    }

    private static Stream<FilterAndInvoker> wrapAllInSafeInvoker(List<FilterAndInvoker> filterInvokers) {
        return filterInvokers.stream().map(filterAndInvoker -> new FilterAndInvoker(filterAndInvoker.filter(), new SafeInvoker(filterAndInvoker.invoker())));
    }

    private static void validateFilter(Filter filter, boolean isResponseFilter, boolean isRequestFilter, boolean isAnySpecificFilterInterface) {
        if (isAnySpecificFilterInterface && (isRequestFilter || isResponseFilter)) {
            throw FilterInvokers.unsupportedFilterInstance(filter, "Cannot mix specific message filter interfaces and [RequestFilter|ResponseFilter] interfaces");
        }
        if (!(isRequestFilter || isResponseFilter || isAnySpecificFilterInterface)) {
            throw FilterInvokers.unsupportedFilterInstance(filter, "Filter must implement ResponseFilter, RequestFilter or any combination of specific message Filter interfaces");
        }
    }

    private static List<FilterAndInvoker> singleFilterAndInvoker(Filter filter, FilterInvoker invoker) {
        return List.of(new FilterAndInvoker(filter, invoker));
    }

    public static FilterInvoker arrayInvoker(Filter filter) {
        return new SpecificFilterArrayInvoker(filter);
    }

    public static FilterInvoker handleNothingInvoker() {
        return HandleNothingFilterInvoker.INSTANCE;
    }

    private static IllegalArgumentException unsupportedFilterInstance(Filter filter, String message) {
        return new IllegalArgumentException("Invoker could not be created for: " + filter.getClass().getName() + ". " + message);
    }
}

