/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.frame;

import io.kroxylicious.proxy.frame.ByteBufAccessor;
import io.kroxylicious.proxy.frame.Frame;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpaqueFrame
implements Frame {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpaqueFrame.class);
    private static final int FRAME_SIZE_LENGTH = 4;
    protected final int length;
    protected final int correlationId;
    protected final ByteBuf buf;

    OpaqueFrame(ByteBuf buf, int correlationId, int length) {
        this.length = length;
        this.correlationId = correlationId;
        this.buf = buf.asReadOnly();
        if (buf.readableBytes() != length) {
            throw new AssertionError((Object)("readable: " + buf.readableBytes() + " length: " + length));
        }
    }

    @Override
    public int correlationId() {
        return this.correlationId;
    }

    @Override
    public int estimateEncodedSize() {
        return 4 + this.length;
    }

    @Override
    public void encode(ByteBufAccessor out) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Writing {} with 4 byte length ({}) plus {} bytes from buffer {} to {}", new Object[]{this.getClass().getSimpleName(), this.length, this.buf.readableBytes(), this.buf, out});
        }
        out.ensureWritable(this.estimateEncodedSize());
        out.writeInt(this.length);
        out.writeBytes(this.buf, this.length);
        this.buf.release();
    }

    public ByteBuf buf() {
        return this.buf;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(length=" + this.length + ", buf=" + String.valueOf(this.buf) + ")";
    }
}

