/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import java.util.HashSet;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiVersionsServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiVersionsServiceImpl.class);

    public void updateVersions(String channel, ApiVersionsResponseData apiVersionsResponse) {
        ApiVersionsServiceImpl.intersectApiVersions(channel, apiVersionsResponse);
    }

    private static void intersectApiVersions(String channel, ApiVersionsResponseData resp) {
        HashSet<ApiVersionsResponseData.ApiVersion> unknownApis = new HashSet<ApiVersionsResponseData.ApiVersion>();
        for (ApiVersionsResponseData.ApiVersion key : resp.apiKeys()) {
            short apiId = key.apiKey();
            if (ApiKeys.hasId((int)apiId)) {
                ApiKeys apiKey = ApiKeys.forId((int)apiId);
                ApiVersionsServiceImpl.intersectApiVersion(channel, key, apiKey);
                continue;
            }
            unknownApis.add(key);
        }
        resp.apiKeys().removeAll(unknownApis);
    }

    private static void intersectApiVersion(String channel, ApiVersionsResponseData.ApiVersion key, ApiKeys apiKey) {
        short mutualMin = (short)Math.max(key.minVersion(), apiKey.messageType.lowestSupportedVersion());
        if (mutualMin != key.minVersion()) {
            LOGGER.trace("{}: {} min version changed to {} (was: {})", new Object[]{channel, apiKey, mutualMin, key.maxVersion()});
            key.setMinVersion(mutualMin);
        } else {
            LOGGER.trace("{}: {} min version unchanged (is: {})", new Object[]{channel, apiKey, mutualMin});
        }
        short mutualMax = (short)Math.min(key.maxVersion(), apiKey.messageType.highestSupportedVersion(true));
        if (mutualMax != key.maxVersion()) {
            LOGGER.trace("{}: {} max version changed to {} (was: {})", new Object[]{channel, apiKey, mutualMin, key.maxVersion()});
            key.setMaxVersion(mutualMax);
        } else {
            LOGGER.trace("{}: {} max version unchanged (is: {})", new Object[]{channel, apiKey, mutualMin});
        }
    }
}

