/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.kroxylicious.proxy.filter.FilterDispatchExecutor;
import io.kroxylicious.proxy.internal.InternalCompletableFuture;
import io.netty.channel.EventLoop;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class NettyFilterDispatchExecutor
implements FilterDispatchExecutor {
    private final EventLoop eventLoop;

    private NettyFilterDispatchExecutor(@NonNull EventLoop eventLoop) {
        Objects.requireNonNull(eventLoop, "eventLoop cannot be null");
        this.eventLoop = eventLoop;
    }

    public static FilterDispatchExecutor eventLoopExecutor(@NonNull EventLoop loop) {
        return new NettyFilterDispatchExecutor(loop);
    }

    public boolean isInFilterDispatchThread() {
        return this.eventLoop.inEventLoop();
    }

    EventLoop getEventLoop() {
        return this.eventLoop;
    }

    public <T> CompletionStage<T> completeOnFilterDispatchThread(@NonNull CompletionStage<T> completionStage) {
        Objects.requireNonNull(completionStage, "completionStage was null");
        InternalCompletableFuture future = new InternalCompletableFuture((Executor)((Object)this));
        completionStage.whenComplete((value, throwable) -> {
            if (this.isInFilterDispatchThread()) {
                NettyFilterDispatchExecutor.forward(value, throwable, future);
            } else {
                this.execute(() -> NettyFilterDispatchExecutor.forward(value, throwable, future));
            }
        });
        return ((CompletableFuture)future).minimalCompletionStage();
    }

    private static <T> void forward(T value, Throwable throwable, CompletableFuture<T> future) {
        if (throwable != null) {
            future.completeExceptionally(throwable);
        } else {
            future.complete(value);
        }
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.eventLoop.schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.eventLoop.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.eventLoop.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.eventLoop.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public void shutdown() {
    }

    public List<Runnable> shutdownNow() {
        return List.of();
    }

    public boolean isShutdown() {
        return this.eventLoop.isShutdown();
    }

    public boolean isTerminated() {
        return this.eventLoop.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.eventLoop.awaitTermination(timeout, unit);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.eventLoop.submit(task);
    }

    @NonNull
    public <T> Future<T> submit(Runnable task, T result) {
        return this.eventLoop.submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.eventLoop.submit(task);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.eventLoop.invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.eventLoop.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.eventLoop.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.eventLoop.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.eventLoop.execute(command);
    }
}

