/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import io.kroxylicious.proxy.model.VirtualCluster;
import io.kroxylicious.proxy.service.HostPort;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PortConflictDetector {
    private static final Optional<String> ANY_INTERFACE = Optional.empty();
    private static final String ANY_STRING = "<any>";

    public void validate(Collection<VirtualCluster> virtualClusterMap, Optional<HostPort> otherExclusivePort) {
        HashSet seenVirtualClusters = new HashSet();
        HashMap inUseExclusivePorts = new HashMap();
        HashMap inUseSharedPorts = new HashMap();
        virtualClusterMap.stream().sorted(Comparator.comparing(VirtualCluster::getClusterName)).forEach(virtualCluster -> {
            String name = virtualCluster.getClusterName();
            Set<Integer> proposedSharedPorts = virtualCluster.getSharedPorts();
            Set<Integer> proposedExclusivePorts = virtualCluster.getExclusivePorts();
            if (otherExclusivePort.isPresent()) {
                boolean checkPorts;
                Optional<String> otherInterface = otherExclusivePort.map(hostPort -> hostPort.host().equals("0.0.0.0") ? null : hostPort.host());
                boolean bl = checkPorts = virtualCluster.getBindAddress().isEmpty() || otherInterface.isEmpty() || virtualCluster.getBindAddress().equals(otherInterface);
                if (checkPorts) {
                    this.checkForConflictsWithOtherExclusivePort((HostPort)otherExclusivePort.get(), name, (VirtualCluster)virtualCluster, proposedExclusivePorts, BindingScope.EXCLUSIVE);
                    this.checkForConflictsWithOtherExclusivePort((HostPort)otherExclusivePort.get(), name, (VirtualCluster)virtualCluster, proposedSharedPorts, BindingScope.SHARED);
                }
            }
            Set<Optional<String>> exclusiveCheckSet = virtualCluster.getBindAddress().isEmpty() ? inUseExclusivePorts.keySet() : Set.of(ANY_INTERFACE, virtualCluster.getBindAddress());
            this.assertExclusivePortsAreMutuallyExclusive(seenVirtualClusters, inUseExclusivePorts, (VirtualCluster)virtualCluster, name, proposedExclusivePorts, exclusiveCheckSet);
            this.assertSharedPortsDoNotOverlapWithExlusivePorts(seenVirtualClusters, inUseExclusivePorts, (VirtualCluster)virtualCluster, name, proposedSharedPorts, exclusiveCheckSet);
            this.assertExclusivePortsDoNotOverlapWithExclusivePorts(seenVirtualClusters, inUseSharedPorts, (VirtualCluster)virtualCluster, name, proposedExclusivePorts, exclusiveCheckSet);
            this.assertSharedPortsAreExclusiveAcrossInterfaces(seenVirtualClusters, inUseSharedPorts, (VirtualCluster)virtualCluster, name, proposedSharedPorts, exclusiveCheckSet);
            this.assertSharedPortsHaveMatchingTlsConfiguration(seenVirtualClusters, inUseSharedPorts, (VirtualCluster)virtualCluster, name, proposedSharedPorts);
            seenVirtualClusters.add(name);
            inUseExclusivePorts.computeIfAbsent(virtualCluster.getBindAddress(), k -> new HashSet()).addAll(proposedExclusivePorts);
            Map sharedMap = inUseSharedPorts.computeIfAbsent(virtualCluster.getBindAddress(), k -> new HashMap());
            proposedSharedPorts.forEach(p -> sharedMap.put(p, virtualCluster.isUseTls()));
        });
    }

    private void assertSharedPortsHaveMatchingTlsConfiguration(Set<String> seenVirtualClusters, Map<Optional<String>, Map<Integer, Boolean>> inUseSharedPorts, VirtualCluster virtualCluster, String name, Set<Integer> proposedSharedPorts) {
        proposedSharedPorts.forEach(p -> {
            Boolean tls = (Boolean)inUseSharedPorts.getOrDefault(virtualCluster.getBindAddress(), Map.of()).get(p);
            if (tls != null && !tls.equals(virtualCluster.isUseTls())) {
                throw this.buildOverviewException(name, seenVirtualClusters, this.buildTlsConflictException((Integer)p, virtualCluster.getBindAddress()));
            }
        });
    }

    private void assertSharedPortsAreExclusiveAcrossInterfaces(Set<String> seenVirtualClusters, Map<Optional<String>, Map<Integer, Boolean>> inUseSharedPorts, VirtualCluster virtualCluster, String name, Set<Integer> proposedSharedPorts, Set<Optional<String>> exclusiveCheckSet) {
        HashSet<Optional<String>> sharedCheckSet = new HashSet<Optional<String>>(exclusiveCheckSet);
        sharedCheckSet.remove(virtualCluster.getBindAddress());
        inUseSharedPorts.entrySet().stream().filter(interfacePortsEntry -> sharedCheckSet.contains(interfacePortsEntry.getKey())).forEach(entry -> {
            Optional bindingInterface = (Optional)entry.getKey();
            Set<Integer> ports = ((Map)entry.getValue()).keySet();
            List<Integer> conflicts = this.getSortedPortConflicts(ports, proposedSharedPorts);
            if (!conflicts.isEmpty()) {
                throw this.buildPortConflictException(name, seenVirtualClusters, conflicts, virtualCluster.getBindAddress(), BindingScope.SHARED, bindingInterface, BindingScope.SHARED);
            }
        });
    }

    private void assertExclusivePortsDoNotOverlapWithExclusivePorts(Set<String> seenVirtualClusters, Map<Optional<String>, Map<Integer, Boolean>> inUseSharedPorts, VirtualCluster virtualCluster, String name, Set<Integer> proposedExclusivePorts, Set<Optional<String>> exclusiveCheckSet) {
        inUseSharedPorts.entrySet().stream().filter(interfacePortsEntry -> exclusiveCheckSet.contains(interfacePortsEntry.getKey())).forEach(entry -> {
            Optional bindingInterface = (Optional)entry.getKey();
            Set<Integer> ports = ((Map)entry.getValue()).keySet();
            List<Integer> conflicts = this.getSortedPortConflicts(ports, proposedExclusivePorts);
            if (!conflicts.isEmpty()) {
                throw this.buildPortConflictException(name, seenVirtualClusters, conflicts, virtualCluster.getBindAddress(), BindingScope.EXCLUSIVE, bindingInterface, BindingScope.SHARED);
            }
        });
    }

    private void assertSharedPortsDoNotOverlapWithExlusivePorts(Set<String> seenVirtualClusters, Map<Optional<String>, Set<Integer>> inUseExclusivePorts, VirtualCluster virtualCluster, String name, Set<Integer> proposedSharedPorts, Set<Optional<String>> exclusiveCheckSet) {
        inUseExclusivePorts.entrySet().stream().filter(interfacePortsEntry -> exclusiveCheckSet.contains(interfacePortsEntry.getKey())).forEach(entry -> {
            Optional bindingInterface = (Optional)entry.getKey();
            Set ports = (Set)entry.getValue();
            List<Integer> conflicts = this.getSortedPortConflicts(ports, proposedSharedPorts);
            if (!conflicts.isEmpty()) {
                throw this.buildPortConflictException(name, seenVirtualClusters, conflicts, virtualCluster.getBindAddress(), BindingScope.SHARED, bindingInterface, BindingScope.EXCLUSIVE);
            }
        });
    }

    private void assertExclusivePortsAreMutuallyExclusive(Set<String> seenVirtualClusters, Map<Optional<String>, Set<Integer>> inUseExclusivePorts, VirtualCluster virtualCluster, String name, Set<Integer> proposedExclusivePorts, Set<Optional<String>> exclusiveCheckSet) {
        inUseExclusivePorts.entrySet().stream().filter(interfacePortsEntry -> exclusiveCheckSet.contains(interfacePortsEntry.getKey())).forEach(entry -> {
            Optional bindingInterface = (Optional)entry.getKey();
            Set ports = (Set)entry.getValue();
            List<Integer> conflicts = this.getSortedPortConflicts(ports, proposedExclusivePorts);
            if (!conflicts.isEmpty()) {
                throw this.buildPortConflictException(name, seenVirtualClusters, conflicts, virtualCluster.getBindAddress(), BindingScope.EXCLUSIVE, bindingInterface, BindingScope.EXCLUSIVE);
            }
        });
    }

    private void checkForConflictsWithOtherExclusivePort(HostPort otherHostPort, String name, VirtualCluster cluster, Set<Integer> proposedExclusivePorts, BindingScope scope) {
        Set<Integer> ports = Set.of(Integer.valueOf(otherHostPort.port()));
        List<Integer> conflicts = this.getSortedPortConflicts(ports, proposedExclusivePorts);
        if (!conflicts.isEmpty()) {
            Optional<String> proposedBindingInterface = cluster.getBindAddress();
            String portConflicts = conflicts.stream().map(String::valueOf).collect(Collectors.joining(","));
            throw new IllegalStateException("The %s bind of port(s) %s for virtual cluster '%s' to %s would conflict with another (non-cluster) port binding".formatted(scope.name().toLowerCase(Locale.ROOT), portConflicts, name, proposedBindingInterface.orElse(ANY_STRING)));
        }
    }

    private List<Integer> getSortedPortConflicts(Set<Integer> ports, Set<Integer> candidates) {
        return ports.stream().filter(candidates::contains).sorted().toList();
    }

    private IllegalStateException buildPortConflictException(String virtualClusterName, Set<String> seenVirtualClusters, List<Integer> conflicts, Optional<String> proposedBindingInterface, BindingScope proposedScope, Optional<String> existingBindingInterface, BindingScope existingBindingScope) {
        String portConflicts = conflicts.stream().map(String::valueOf).collect(Collectors.joining(","));
        IllegalStateException underlying = new IllegalStateException("The %s bind of port(s) %s to %s would conflict with existing %s port bindings on %s.".formatted(proposedScope.name().toLowerCase(Locale.ROOT), portConflicts, proposedBindingInterface.orElse(ANY_STRING), existingBindingScope.name().toLowerCase(Locale.ROOT), existingBindingInterface.orElse(ANY_STRING)));
        return this.buildOverviewException(virtualClusterName, seenVirtualClusters, underlying);
    }

    private IllegalStateException buildTlsConflictException(Integer port, Optional<String> bindingAddress) {
        return new IllegalStateException("The shared bind of port %d to %s has conflicting TLS settings with existing port on the same interface.".formatted(port, bindingAddress.orElse(ANY_STRING)));
    }

    private IllegalStateException buildOverviewException(String virtualClusterName, Set<String> seenVirtualClusters, IllegalStateException underlying) {
        String seenVirtualClustersString = seenVirtualClusters.stream().sorted().map(s -> "'" + s + "'").collect(Collectors.joining(","));
        return new IllegalStateException("Configuration for virtual cluster '%s' conflicts with configuration for virtual cluster%s: %s.".formatted(virtualClusterName, seenVirtualClusters.size() > 1 ? "s" : "", seenVirtualClustersString), underlying);
    }

    private static enum BindingScope {
        SHARED,
        EXCLUSIVE;

    }
}

