/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal;

import io.kroxylicious.proxy.internal.InternalCompletableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PromiseFactory {
    private final ScheduledExecutorService executorService;
    private final long timeout;
    private final TimeUnit timeoutUnit;
    private final Logger logger;

    PromiseFactory(ScheduledExecutorService executorService, long timeout, TimeUnit timeoutUnit, String loggerName) {
        this.executorService = executorService;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
        this.logger = LoggerFactory.getLogger((String)loggerName);
    }

    <T> CompletableFuture<T> newPromise() {
        return new InternalCompletableFuture(this.executorService);
    }

    <T> CompletableFuture<T> newTimeLimitedPromise(Callable<String> exceptionMessageGenerator) {
        return this.wrapWithTimeLimit(this.newPromise(), exceptionMessageGenerator);
    }

    <T> CompletableFuture<T> wrapWithTimeLimit(CompletableFuture<T> promise, Callable<String> exceptionMessageGenerator) {
        ScheduledFuture<?> timeoutFuture = this.executorService.schedule(this.timeoutTask(promise, exceptionMessageGenerator), this.timeout, this.timeoutUnit);
        promise.whenComplete((p, throwable) -> timeoutFuture.cancel(false));
        return promise;
    }

    protected <T> Runnable timeoutTask(CompletableFuture<T> promise, Callable<String> exceptionMessageGenerator) {
        return () -> {
            try {
                String message = (String)exceptionMessageGenerator.call();
                this.logger.warn(message);
                promise.completeExceptionally(new TimeoutException(message));
            }
            catch (Exception e) {
                this.logger.warn("Timeout exceptionMessageGenerator failed with {}. The promise has still been timed out.", (Object)e.getMessage(), (Object)e);
                promise.completeExceptionally(new TimeoutException("Promise Timed out"));
            }
        };
    }
}

