/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.admin;

import io.kroxylicious.proxy.config.admin.AdminHttpConfiguration;
import io.kroxylicious.proxy.internal.MeterRegistries;
import io.kroxylicious.proxy.internal.admin.PrometheusMetricsEndpoint;
import io.kroxylicious.proxy.internal.admin.RoutingHttpServer;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;

public class AdminHttpInitializer
extends ChannelInitializer<SocketChannel> {
    private final MeterRegistries registries;
    private final AdminHttpConfiguration adminHttpConfiguration;

    public AdminHttpInitializer(MeterRegistries registries, AdminHttpConfiguration adminHttpConfiguration) {
        this.registries = registries;
        this.adminHttpConfiguration = adminHttpConfiguration;
    }

    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new HttpServerCodec()});
        p.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
        RoutingHttpServer.RoutingHttpServerBuilder builder = RoutingHttpServer.builder();
        this.adminHttpConfiguration.endpoints().maybePrometheus().ifPresent(prometheusMetricsConfig -> builder.withRoute(PrometheusMetricsEndpoint.PATH, new PrometheusMetricsEndpoint(this.registries)));
        p.addLast(new ChannelHandler[]{builder.build()});
    }
}

