/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.admin;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.rtsp.RtspHeaderNames;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoutingHttpServer
extends SimpleChannelInboundHandler<HttpObject> {
    private final Map<String, Function<HttpRequest, HttpResponse>> routes;
    private static final Logger LOGGER = LoggerFactory.getLogger(RoutingHttpServer.class);

    public RoutingHttpServer(Map<String, Function<HttpRequest, HttpResponse>> routes) {
        this.routes = routes;
    }

    public static RoutingHttpServerBuilder builder() {
        return new RoutingHttpServerBuilder();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
            HttpResponse response = this.getResponse(req);
            if (keepAlive) {
                if (!req.protocolVersion().isKeepAliveDefault()) {
                    response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                }
            } else {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            }
            ChannelFuture f = ctx.write((Object)response);
            if (!keepAlive) {
                f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
    }

    private HttpResponse getResponse(HttpRequest req) {
        if (this.routes.containsKey(req.uri())) {
            try {
                return this.routes.get(req.uri()).apply(req);
            }
            catch (Exception e) {
                LOGGER.error("exception while invoking endpoint for route {}", (Object)req.uri(), (Object)e);
                return RoutingHttpServer.responseWithStatus(req, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return RoutingHttpServer.responseWithStatus(req, HttpResponseStatus.NOT_FOUND);
    }

    public static FullHttpResponse responseWithStatus(HttpRequest req, HttpResponseStatus status) {
        return RoutingHttpServer.responseWithBody(req, status, status.reasonPhrase());
    }

    public static FullHttpResponse responseWithBody(HttpRequest req, HttpResponseStatus status, String content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(req.protocolVersion(), status, Unpooled.wrappedBuffer((byte[])content.getBytes(StandardCharsets.UTF_8)));
        response.headers().set((CharSequence)RtspHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN).setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        return response;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.error("exception caught in MetricsServer", cause);
        ctx.close();
    }

    static class RoutingHttpServerBuilder {
        private final Map<String, Function<HttpRequest, HttpResponse>> routes = new HashMap<String, Function<HttpRequest, HttpResponse>>();

        RoutingHttpServerBuilder() {
        }

        RoutingHttpServerBuilder withRoute(String path, Function<HttpRequest, HttpResponse> responseFunction) {
            this.routes.put(path, responseFunction);
            return this;
        }

        RoutingHttpServer build() {
            return new RoutingHttpServer(this.routes);
        }
    }
}

