/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider.RangeAwarePortPerNodeClusterNetworkAddressConfigProvider;
import io.kroxylicious.proxy.service.HostPort;
import java.util.List;
import java.util.Objects;

public class PortPerBrokerClusterNetworkAddressConfigProvider
extends RangeAwarePortPerNodeClusterNetworkAddressConfigProvider {
    public PortPerBrokerClusterNetworkAddressConfigProvider(PortPerBrokerClusterNetworkAddressConfigProviderConfig config) {
        super(config.rangeAwareConfig);
    }

    public static class PortPerBrokerClusterNetworkAddressConfigProviderConfig {
        @JsonIgnore
        private final RangeAwarePortPerNodeClusterNetworkAddressConfigProvider.RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig rangeAwareConfig;
        private final HostPort bootstrapAddress;
        private final String brokerAddressPattern;
        private final int brokerStartPort;
        private final int lowestTargetBrokerId;
        private final int numberOfBrokerPorts;

        public PortPerBrokerClusterNetworkAddressConfigProviderConfig(@JsonProperty(required=true) HostPort bootstrapAddress, @JsonProperty(required=false) String brokerAddressPattern, @JsonProperty(required=false) Integer brokerStartPort, @JsonProperty(required=false, defaultValue="0") Integer lowestTargetBrokerId, @JsonProperty(required=false, defaultValue="3") Integer numberOfBrokerPorts) {
            Objects.requireNonNull(bootstrapAddress, "bootstrapAddress cannot be null");
            this.bootstrapAddress = bootstrapAddress;
            this.brokerAddressPattern = brokerAddressPattern != null ? brokerAddressPattern : bootstrapAddress.host();
            this.brokerStartPort = brokerStartPort != null ? brokerStartPort : bootstrapAddress.port() + 1;
            this.lowestTargetBrokerId = lowestTargetBrokerId != null ? lowestTargetBrokerId : 0;
            int n = this.numberOfBrokerPorts = numberOfBrokerPorts != null ? numberOfBrokerPorts : 3;
            if (this.brokerStartPort < 1) {
                throw new IllegalArgumentException("brokerStartPort cannot be less than 1");
            }
            if (this.numberOfBrokerPorts < 1) {
                throw new IllegalArgumentException("numberOfBrokerPorts cannot be less than 1");
            }
            this.rangeAwareConfig = new RangeAwarePortPerNodeClusterNetworkAddressConfigProvider.RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig(this.bootstrapAddress, this.brokerAddressPattern, this.brokerStartPort, List.of(new RangeAwarePortPerNodeClusterNetworkAddressConfigProvider.NamedRangeSpec("brokers", new RangeAwarePortPerNodeClusterNetworkAddressConfigProvider.IntRangeSpec(this.lowestTargetBrokerId, this.lowestTargetBrokerId + this.numberOfBrokerPorts))));
        }

        public HostPort getBootstrapAddress() {
            return this.bootstrapAddress;
        }
    }
}

