/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.stream.IntStream;

public record Range(int startInclusive, int endExclusive) {
    public Range {
        if (endExclusive <= startInclusive) {
            throw new IllegalArgumentException("end of range: " + endExclusive + " (exclusive) is before start of range: " + startInclusive + " (inclusive)");
        }
    }

    @NonNull
    public IntStream values() {
        return IntStream.range(this.startInclusive, this.endExclusive);
    }

    boolean isEndBeforeStartOf(@NonNull Range range) {
        Objects.requireNonNull(range, "range to compare with is null");
        return this.endExclusive <= range.startInclusive;
    }

    public boolean isDistinctFrom(@NonNull Range range) {
        Objects.requireNonNull(range, "range to compare with is null");
        return this.isEndBeforeStartOf(range) || range.isEndBeforeStartOf(this);
    }

    @Override
    public String toString() {
        return "[" + this.startInclusive + "," + this.endExclusive + ")";
    }
}

