/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider.BrokerAddressPatternUtils;
import io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider.Range;
import io.kroxylicious.proxy.service.ClusterNetworkAddressConfigProvider;
import io.kroxylicious.proxy.service.HostPort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RangeAwarePortPerNodeClusterNetworkAddressConfigProvider
implements ClusterNetworkAddressConfigProvider {
    private final HostPort bootstrapAddress;
    private final String nodeAddressPattern;
    private final Set<Integer> exclusivePorts;
    private final Map<Integer, Integer> nodeIdToPort;

    public RangeAwarePortPerNodeClusterNetworkAddressConfigProvider(RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig config) {
        this.bootstrapAddress = config.bootstrapAddress;
        this.nodeAddressPattern = config.nodeAddressPattern;
        this.nodeIdToPort = config.nodeIdToPort;
        HashSet<Integer> allExclusivePorts = new HashSet<Integer>(this.nodeIdToPort.values());
        allExclusivePorts.add(this.bootstrapAddress.port());
        this.exclusivePorts = Collections.unmodifiableSet(allExclusivePorts);
    }

    @Override
    public HostPort getClusterBootstrapAddress() {
        return this.bootstrapAddress;
    }

    @Override
    public HostPort getBrokerAddress(int nodeId) throws IllegalArgumentException {
        if (!this.nodeIdToPort.containsKey(nodeId)) {
            throw new IllegalArgumentException("Cannot generate node address for node id %d as it is not contained in the ranges defined for provider with downstream bootstrap %s".formatted(nodeId, this.bootstrapAddress));
        }
        int port = this.nodeIdToPort.get(nodeId);
        return new HostPort(BrokerAddressPatternUtils.replaceLiteralNodeId(this.nodeAddressPattern, nodeId), port);
    }

    @Override
    public Set<Integer> getExclusivePorts() {
        return this.exclusivePorts;
    }

    @Override
    public Map<Integer, HostPort> discoveryAddressMap() {
        return this.nodeIdToPort.keySet().stream().collect(Collectors.toMap(Function.identity(), this::getBrokerAddress));
    }

    public static class RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig {
        private final HostPort bootstrapAddress;
        private final String nodeAddressPattern;
        private final int nodeStartPort;
        @JsonIgnore
        private final Map<Integer, Integer> nodeIdToPort;
        private final List<NamedRangeSpec> nodeIdRanges;

        public RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig(@JsonProperty(required=true) HostPort bootstrapAddress, @JsonProperty(required=false) String nodeAddressPattern, @JsonProperty(required=false) Integer nodeStartPort, @JsonProperty(required=true) List<NamedRangeSpec> nodeIdRanges) {
            Objects.requireNonNull(bootstrapAddress, "bootstrapAddress cannot be null");
            if (nodeIdRanges.isEmpty()) {
                throw new IllegalArgumentException("node id ranges empty");
            }
            this.bootstrapAddress = bootstrapAddress;
            this.nodeAddressPattern = nodeAddressPattern != null ? nodeAddressPattern : bootstrapAddress.host();
            this.verifyNodeAddressPattern();
            int n = this.nodeStartPort = nodeStartPort != null ? nodeStartPort : bootstrapAddress.port() + 1;
            if (this.nodeStartPort < 1) {
                throw new IllegalArgumentException("nodeStartPort cannot be less than 1");
            }
            List<NamedRange> namedRanges = nodeIdRanges.stream().map(NamedRangeSpec::range).toList();
            RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig.verifyRangeNamesAreUnique(namedRanges);
            RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig.verifyRangesAreDistinct(namedRanges);
            this.nodeIdToPort = RangeAwarePortPerNodeClusterNetworkAddressConfigProviderConfig.mapNodeIdToPort(namedRanges, this.nodeStartPort);
            int numberOfNodePorts = this.nodeIdToPort.size();
            if (this.nodeStartPort + numberOfNodePorts - 1 > 65535) {
                throw new IllegalArgumentException("The maximum port mapped exceeded 65535");
            }
            this.verifyNoRangeContainsBootstrapPort(bootstrapAddress, namedRanges);
            this.nodeIdRanges = nodeIdRanges;
        }

        private void verifyNoRangeContainsBootstrapPort(HostPort bootstrapAddress, List<NamedRange> namedRanges) {
            for (NamedRange namedRange : namedRanges) {
                namedRange.range().values().forEach(value -> {
                    if (Objects.equals(this.nodeIdToPort.get(value), this.bootstrapAddress.port())) {
                        Range range = namedRange.range;
                        Range portRange = new Range(range.startInclusive() + this.nodeStartPort, range.endExclusive() + this.nodeStartPort);
                        throw new IllegalArgumentException("the port used by the bootstrap address (%d) collides with the node id range: %s mapped to ports %s".formatted(bootstrapAddress.port(), namedRange, portRange));
                    }
                });
            }
        }

        private void verifyNodeAddressPattern() {
            if (this.nodeAddressPattern.isBlank()) {
                throw new IllegalArgumentException("nodeAddressPattern cannot be blank");
            }
            BrokerAddressPatternUtils.validatePortSpecifier(this.nodeAddressPattern, s -> {
                throw new IllegalArgumentException("nodeAddressPattern cannot have port specifier.  Found port : " + s + " within " + this.nodeAddressPattern);
            });
            BrokerAddressPatternUtils.validateStringContainsOnlyExpectedTokens(this.nodeAddressPattern, BrokerAddressPatternUtils.EXPECTED_TOKEN_SET, token -> {
                throw new IllegalArgumentException("nodeAddressPattern contains an unexpected replacement token '" + token + "'");
            });
        }

        private static void verifyRangeNamesAreUnique(List<NamedRange> namedRanges) {
            Map<String, List<NamedRange>> collect = namedRanges.stream().collect(Collectors.groupingBy(namedRange -> namedRange.name));
            List<String> nonUniqueNames = collect.entrySet().stream().filter(stringListEntry -> ((List)stringListEntry.getValue()).size() > 1).map(Map.Entry::getKey).toList();
            if (!nonUniqueNames.isEmpty()) {
                throw new IllegalArgumentException("non-unique nodeIdRange names discovered: " + String.valueOf(nonUniqueNames));
            }
        }

        private static Map<Integer, Integer> mapNodeIdToPort(List<NamedRange> ranges, Integer nodeStartPort) {
            IntStream unsortedNodeIds = ranges.stream().flatMapToInt(rangeSpec -> rangeSpec.range().values());
            List<Integer> ascendingNodeIds = unsortedNodeIds.distinct().sorted().boxed().toList();
            HashMap<Integer, Integer> nodeIdToPort = new HashMap<Integer, Integer>();
            for (int offset = 0; offset < ascendingNodeIds.size(); ++offset) {
                nodeIdToPort.put(ascendingNodeIds.get(offset), nodeStartPort + offset);
            }
            return nodeIdToPort;
        }

        public HostPort getBootstrapAddress() {
            return this.bootstrapAddress;
        }

        private static void verifyRangesAreDistinct(List<NamedRange> ranges) {
            ArrayList<RangeCollision> collisions = new ArrayList<RangeCollision>();
            for (int i = 0; i < ranges.size(); ++i) {
                for (int j = 0; j < ranges.size(); ++j) {
                    NamedRange rangeB;
                    NamedRange rangeA;
                    if (j <= i || (rangeA = ranges.get(i)).isDistinctFrom(rangeB = ranges.get(j))) continue;
                    collisions.add(new RangeCollision(rangeA, rangeB));
                }
            }
            if (!collisions.isEmpty()) {
                throw new IllegalArgumentException("some nodeIdRanges collided (one or more node ids are duplicated in the following ranges): " + collisions.stream().map(RangeCollision::toString).collect(Collectors.joining(", ")));
            }
        }

        private record RangeCollision(NamedRange a, NamedRange b) {
            @Override
            public String toString() {
                return "'" + String.valueOf(this.a) + "' collides with '" + String.valueOf(this.b) + "'";
            }
        }
    }

    public record NamedRangeSpec(@JsonProperty(required=true) String name, @JsonProperty(required=true, value="range") IntRangeSpec rangeSpec) {
        NamedRange range() {
            return new NamedRange(this.name, this.tryBuildRange());
        }

        private Range tryBuildRange() {
            try {
                return this.rangeSpec.range();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid nodeIdRange: " + this.name + ", " + e.getMessage(), e);
            }
        }

        @Override
        public String toString() {
            return this.name + ":" + String.valueOf(this.rangeSpec.range());
        }
    }

    private record NamedRange(@NonNull String name, @NonNull Range range) {
        public NamedRange {
            Objects.requireNonNull(name, "name was null");
            Objects.requireNonNull(range, "range was null");
        }

        public boolean isDistinctFrom(NamedRange rangeB) {
            return this.range.isDistinctFrom(rangeB.range);
        }

        @Override
        public String toString() {
            return this.name + ":" + String.valueOf(this.range);
        }
    }

    public record IntRangeSpec(@JsonInclude(value=JsonInclude.Include.ALWAYS) @JsonProperty(required=true) int startInclusive, @JsonInclude(value=JsonInclude.Include.ALWAYS) @JsonProperty(required=true) int endExclusive) {
        public Range range() {
            return new Range(this.startInclusive, this.endExclusive);
        }
    }
}

