/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.kroxylicious.proxy.internal.clusternetworkaddressconfigprovider.BrokerAddressPatternUtils;
import io.kroxylicious.proxy.service.ClusterNetworkAddressConfigProvider;
import io.kroxylicious.proxy.service.HostPort;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SniRoutingClusterNetworkAddressConfigProvider
implements ClusterNetworkAddressConfigProvider {
    private final HostPort bootstrapAddress;
    private final String brokerAddressPattern;
    private final Pattern brokerAddressNodeIdCapturingRegex;

    public SniRoutingClusterNetworkAddressConfigProvider(SniRoutingClusterNetworkAddressConfigProviderConfig config) {
        this.bootstrapAddress = config.bootstrapAddress;
        this.brokerAddressPattern = config.brokerAddressPattern;
        this.brokerAddressNodeIdCapturingRegex = config.brokerAddressNodeIdCapturingRegex;
    }

    @Override
    public HostPort getClusterBootstrapAddress() {
        return this.bootstrapAddress;
    }

    @Override
    public HostPort getBrokerAddress(int nodeId) {
        if (nodeId < 0) {
            throw new IllegalArgumentException("nodeId cannot be less than zero");
        }
        return new HostPort(BrokerAddressPatternUtils.replaceLiteralNodeId(this.brokerAddressPattern, nodeId), this.bootstrapAddress.port());
    }

    @Override
    public Integer getBrokerIdFromBrokerAddress(HostPort brokerAddress) {
        if (brokerAddress.port() != this.bootstrapAddress.port()) {
            return null;
        }
        Matcher matcher = this.brokerAddressNodeIdCapturingRegex.matcher(brokerAddress.host());
        if (matcher.matches()) {
            String nodeId = matcher.group(1);
            try {
                return Integer.valueOf(nodeId);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("unexpected exception parsing : '%s'".formatted(nodeId), e);
            }
        }
        return null;
    }

    @Override
    public Set<Integer> getSharedPorts() {
        return Set.of(Integer.valueOf(this.bootstrapAddress.port()));
    }

    @Override
    public boolean requiresTls() {
        return true;
    }

    public static class SniRoutingClusterNetworkAddressConfigProviderConfig {
        private final HostPort bootstrapAddress;
        private final String brokerAddressPattern;
        @JsonIgnore
        private final Pattern brokerAddressNodeIdCapturingRegex;

        public SniRoutingClusterNetworkAddressConfigProviderConfig(@JsonProperty(required=true) HostPort bootstrapAddress, @JsonProperty(required=true) String brokerAddressPattern) {
            if (bootstrapAddress == null) {
                throw new IllegalArgumentException("bootstrapAddress cannot be null");
            }
            if (brokerAddressPattern == null) {
                throw new IllegalArgumentException("brokerAddressPattern cannot be null");
            }
            BrokerAddressPatternUtils.validatePortSpecifier(brokerAddressPattern, s -> {
                throw new IllegalArgumentException("brokerAddressPattern cannot have port specifier.  Found port : " + s + " within " + brokerAddressPattern);
            });
            BrokerAddressPatternUtils.validateStringContainsOnlyExpectedTokens(brokerAddressPattern, BrokerAddressPatternUtils.EXPECTED_TOKEN_SET, tok -> {
                throw new IllegalArgumentException("brokerAddressPattern contains an unexpected replacement token '" + tok + "'");
            });
            BrokerAddressPatternUtils.validateStringContainsRequiredTokens(brokerAddressPattern, BrokerAddressPatternUtils.EXPECTED_TOKEN_SET, tok -> {
                throw new IllegalArgumentException("brokerAddressPattern must contain at least one nodeId replacement pattern '" + tok + "'");
            });
            this.bootstrapAddress = bootstrapAddress;
            this.brokerAddressPattern = brokerAddressPattern;
            this.brokerAddressNodeIdCapturingRegex = BrokerAddressPatternUtils.createNodeIdCapturingRegex(brokerAddressPattern);
        }

        public HostPort getBootstrapAddress() {
            return this.bootstrapAddress;
        }
    }
}

