/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import io.kroxylicious.proxy.frame.ByteBufAccessor;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;

public class ByteBufAccessorImpl
implements ByteBufAccessor {
    private final ByteBuf buf;

    public ByteBufAccessorImpl(ByteBuf buf) {
        this.buf = buf;
    }

    private static IllegalArgumentException illegalVarintException(int value) {
        throw new IllegalArgumentException("Varint is too long, the most significant bit in the 5th byte is set, converted value: " + Integer.toHexString(value));
    }

    private static IllegalArgumentException illegalVarlongException(long value) {
        throw new IllegalArgumentException("Varlong is too long, most significant bit in the 10th byte is set, converted value: " + Long.toHexString(value));
    }

    private static IllegalArgumentException illegalReadException(int size, int remaining) {
        throw new IllegalArgumentException("Error reading byte array of " + size + " byte(s): only " + remaining + " byte(s) available");
    }

    public static long readVarlong(ByteBuf buffer) {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)buffer.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            if ((i += 7) <= 63) continue;
            throw ByteBufAccessorImpl.illegalVarlongException(value);
        }
        return (value |= b << i) >>> 1 ^ -(value & 1L);
    }

    public static int readUnsignedVarint(ByteBuf buffer) {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = buffer.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 28) continue;
            throw ByteBufAccessorImpl.illegalVarintException(value);
        }
        return value |= b << i;
    }

    public static int readVarint(ByteBuf buffer) {
        int value = ByteBufAccessorImpl.readUnsignedVarint(buffer);
        return value >>> 1 ^ -(value & 1);
    }

    public static void writeVarlong(long value, ByteBuf buffer) {
        long v = value << 1 ^ value >> 63;
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byte b = (byte)(v & 0x7FL | 0x80L);
            buffer.writeByte((int)b);
            v >>>= 7;
        }
        buffer.writeByte((int)((byte)v));
    }

    public static void writeVarint(int value, ByteBuf buffer) {
        ByteBufAccessorImpl.writeUnsignedVarint(value << 1 ^ value >> 31, buffer);
    }

    public static void writeUnsignedVarint(int value, ByteBuf buffer) {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            byte b = (byte)(value & 0x7F | 0x80);
            buffer.writeByte((int)b);
            value >>>= 7;
        }
        buffer.writeByte((int)((byte)value));
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public short readShort() {
        return this.buf.readShort();
    }

    @Override
    public int readInt() {
        return this.buf.readInt();
    }

    @Override
    public long readLong() {
        return this.buf.readLong();
    }

    @Override
    public double readDouble() {
        return this.buf.readDouble();
    }

    @Override
    public byte[] readArray(int size) {
        int remaining = this.buf.readableBytes();
        if (size > remaining) {
            throw ByteBufAccessorImpl.illegalReadException(size, remaining);
        }
        byte[] dst = new byte[size];
        this.buf.readBytes(dst, 0, size);
        return dst;
    }

    @Override
    public int readUnsignedVarint() {
        return ByteBufAccessorImpl.readUnsignedVarint(this.buf);
    }

    @Override
    public ByteBuffer readByteBuffer(int length) {
        ByteBuffer wrap = ByteBuffer.wrap(ByteBufUtil.getBytes((ByteBuf)this.buf, (int)this.buf.readerIndex(), (int)length, (boolean)false));
        this.buf.readerIndex(this.buf.readerIndex() + length);
        return wrap;
    }

    @Override
    public int readVarint() {
        return ByteBufAccessorImpl.readVarint(this.buf);
    }

    @Override
    public long readVarlong() {
        return ByteBufAccessorImpl.readVarlong(this.buf);
    }

    @Override
    public int remaining() {
        return this.buf.writerIndex() - this.buf.readerIndex();
    }

    @Override
    public int readerIndex() {
        return this.buf.readerIndex();
    }

    @Override
    public void readerIndex(int readerIndex) {
        this.buf.readerIndex(readerIndex);
    }

    @Override
    public void writeByte(byte val) {
        this.buf.writeByte((int)val);
    }

    @Override
    public void writeShort(short val) {
        this.buf.writeShort((int)val);
    }

    @Override
    public void writeInt(int val) {
        this.buf.writeInt(val);
    }

    @Override
    public void writeLong(long val) {
        this.buf.writeLong(val);
    }

    @Override
    public void writeDouble(double val) {
        this.buf.writeDouble(val);
    }

    @Override
    public void writeByteArray(byte[] arr) {
        this.buf.writeBytes(arr);
    }

    @Override
    public void writeUnsignedVarint(int i) {
        ByteBufAccessorImpl.writeUnsignedVarint(i, this.buf);
    }

    @Override
    public void writeByteBuffer(ByteBuffer byteBuffer) {
        this.buf.writeBytes(byteBuffer);
    }

    @Override
    public void writeVarint(int i) {
        ByteBufAccessorImpl.writeVarint(i, this.buf);
    }

    @Override
    public void writeVarlong(long i) {
        ByteBufAccessorImpl.writeVarlong(i, this.buf);
    }

    @Override
    public void ensureWritable(int encodedSize) {
        this.buf.ensureWritable(encodedSize);
    }

    @Override
    public int writerIndex() {
        return this.buf.writerIndex();
    }

    @Override
    public void writeBytes(ByteBuf buf, int length) {
        this.buf.writeBytes(buf, length);
    }
}

