/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import io.kroxylicious.proxy.filter.Filter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorrelationManager.class);
    final Map<Integer, Correlation> brokerRequests = new HashMap<Integer, Correlation>();
    private int upstreamId;

    public CorrelationManager() {
        this(0);
    }

    public CorrelationManager(int initialCorrelationId) {
        this.upstreamId = initialCorrelationId;
    }

    public int putBrokerRequest(short apiKey, short apiVersion, int downstreamCorrelationId, boolean hasResponse, Filter recipient, CompletableFuture<?> promise, boolean decodeResponse) {
        Correlation existing;
        int upstreamCorrelationId = this.upstreamId++;
        LOGGER.trace("Allocated upstream id {} for downstream id {}", (Object)upstreamCorrelationId, (Object)downstreamCorrelationId);
        if (hasResponse && (existing = this.brokerRequests.put(upstreamCorrelationId, new Correlation(apiKey, apiVersion, downstreamCorrelationId, decodeResponse, recipient, promise))) != null) {
            LOGGER.error("Duplicate upstream correlation id {}", (Object)upstreamCorrelationId);
        }
        return upstreamCorrelationId;
    }

    public Correlation getBrokerCorrelation(int upstreamCorrelationId) {
        return this.brokerRequests.remove(upstreamCorrelationId);
    }

    public static class Correlation {
        private final short apiKey;
        private final short apiVersion;
        private final int downstreamCorrelationId;
        private final boolean decodeResponse;
        private final Filter recipient;
        private final CompletableFuture<?> promise;

        private Correlation(short apiKey, short apiVersion, int downstreamCorrelationId, boolean decodeResponse, Filter recipient, CompletableFuture<?> promise) {
            this.apiKey = apiKey;
            this.apiVersion = apiVersion;
            this.downstreamCorrelationId = downstreamCorrelationId;
            this.decodeResponse = decodeResponse;
            this.recipient = recipient;
            this.promise = promise;
        }

        public int downstreamCorrelationId() {
            return this.downstreamCorrelationId;
        }

        public String toString() {
            return "Correlation(apiKey=" + String.valueOf(ApiKeys.forId((int)this.apiKey)) + ", apiVersion=" + this.apiVersion + ", downstreamCorrelationId=" + this.downstreamCorrelationId + ", decodeResponse=" + this.decodeResponse + ", recipient=" + String.valueOf(this.recipient) + ", promise=" + String.valueOf(this.promise) + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Correlation that = (Correlation)o;
            return this.apiKey == that.apiKey && this.apiVersion == that.apiVersion && this.downstreamCorrelationId == that.downstreamCorrelationId && this.decodeResponse == that.decodeResponse;
        }

        public int hashCode() {
            return Objects.hash(this.apiKey, this.apiVersion, this.downstreamCorrelationId, this.decodeResponse);
        }

        public short apiKey() {
            return this.apiKey;
        }

        public short apiVersion() {
            return this.apiVersion;
        }

        public boolean decodeResponse() {
            return this.decodeResponse;
        }

        public Filter recipient() {
            return this.recipient;
        }

        public CompletableFuture<?> promise() {
            return this.promise;
        }
    }
}

