/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.internal.codec.FrameOversizedException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;

public abstract class KafkaMessageDecoder
extends ByteToMessageDecoder {
    private final int socketFrameMaxSize;

    protected abstract Logger log();

    protected KafkaMessageDecoder(int socketFrameMaxSize) {
        this.socketFrameMaxSize = socketFrameMaxSize;
    }

    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        while (in.readableBytes() > 4) {
            try {
                int sof = in.readerIndex();
                int frameSize = in.readInt();
                if (frameSize > this.socketFrameMaxSize) {
                    throw new FrameOversizedException(this.socketFrameMaxSize, frameSize);
                }
                int readable = in.readableBytes();
                if (this.log().isTraceEnabled()) {
                    this.log().trace("{}: Frame of {} bytes ({} readable)", new Object[]{ctx, frameSize, readable});
                }
                if (readable >= frameSize) {
                    int idx = in.readerIndex();
                    out.add(this.decodeHeaderAndBody(ctx, in.readSlice(frameSize), frameSize));
                    this.log().trace("{}: readable: {}, having read {}", new Object[]{ctx, in.readableBytes(), in.readerIndex() - idx});
                    if (in.readerIndex() - idx == frameSize) continue;
                    throw new RuntimeException("decodeHeaderAndBody did not read all of the buffer " + String.valueOf(in));
                }
                in.readerIndex(sof);
                break;
            }
            catch (Exception e) {
                this.log().error("{}: Error in decoder", (Object)ctx, (Object)e);
                throw e;
            }
        }
    }

    protected abstract Frame decodeHeaderAndBody(ChannelHandlerContext var1, ByteBuf var2, int var3);
}

