/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.internal.codec.ByteBufAccessorImpl;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.slf4j.Logger;

public abstract class KafkaMessageEncoder<F extends Frame>
extends MessageToByteEncoder<F> {
    protected abstract Logger log();

    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, F msg, boolean preferDirect) throws Exception {
        int bytes = msg.estimateEncodedSize();
        if (preferDirect) {
            return ctx.alloc().ioBuffer(bytes);
        }
        return ctx.alloc().heapBuffer(bytes);
    }

    protected void encode(ChannelHandlerContext ctx, F frame, ByteBuf out) throws Exception {
        this.log().trace("{}: Encoding {} to buffer {}", new Object[]{ctx, frame, out});
        frame.encode(new ByteBufAccessorImpl(out));
    }
}

