/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import io.kroxylicious.proxy.frame.DecodedRequestFrame;
import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.frame.OpaqueRequestFrame;
import io.kroxylicious.proxy.frame.RequestFrame;
import io.kroxylicious.proxy.internal.codec.BodyDecoder;
import io.kroxylicious.proxy.internal.codec.ByteBufAccessorImpl;
import io.kroxylicious.proxy.internal.codec.DecodePredicate;
import io.kroxylicious.proxy.internal.codec.KafkaMessageDecoder;
import io.kroxylicious.proxy.internal.util.Metrics;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRequestDecoder
extends KafkaMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaRequestDecoder.class);
    private final DecodePredicate decodePredicate;

    public KafkaRequestDecoder(DecodePredicate decodePredicate, int socketFrameMaxSize) {
        super(socketFrameMaxSize);
        this.decodePredicate = decodePredicate;
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }

    @Override
    protected Frame decodeHeaderAndBody(ChannelHandlerContext ctx, ByteBuf in, int length) {
        RequestFrame frame;
        ByteBufAccessorImpl accessor;
        int sof = in.readerIndex();
        short apiId = in.readShort();
        ApiKeys apiKey = ApiKeys.forId((int)apiId);
        if (this.log().isTraceEnabled()) {
            this.log().trace("{}: apiKey: {} {}", new Object[]{ctx, apiId, apiKey});
        }
        short apiVersion = in.readShort();
        if (this.log().isTraceEnabled()) {
            this.log().trace("{}: apiVersion: {}", (Object)ctx, (Object)apiVersion);
        }
        int startOfMessage = in.readerIndex();
        int correlationId = in.readInt();
        LOGGER.debug("{}: {} downstream correlation id: {}", new Object[]{ctx, apiKey, correlationId});
        RequestHeaderData header = null;
        Metrics.inboundDownstreamMessagesCounter().increment();
        boolean decodeRequest = this.decodePredicate.shouldDecodeRequest(apiKey, apiVersion);
        LOGGER.debug("Decode {}/v{} request? {}, Predicate {} ", new Object[]{apiKey, apiVersion, decodeRequest, this.decodePredicate});
        boolean decodeResponse = this.decodePredicate.shouldDecodeResponse(apiKey, apiVersion);
        LOGGER.debug("Decode {}/v{} response? {}, Predicate {}", new Object[]{apiKey, apiVersion, decodeResponse, this.decodePredicate});
        short headerVersion = apiKey.requestHeaderVersion(apiVersion);
        if (decodeRequest) {
            Metrics.inboundDownstreamDecodedMessagesCounter().increment();
            Metrics.payloadSizeBytesUpstreamSummary(apiKey, apiVersion).record((double)length);
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: headerVersion {}", (Object)ctx, (Object)headerVersion);
            }
            in.readerIndex(sof);
            accessor = new ByteBufAccessorImpl(in);
            header = this.readHeader(headerVersion, accessor);
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: header: {}", (Object)ctx, (Object)header);
            }
        } else {
            accessor = null;
        }
        if (decodeRequest) {
            ApiMessage body = BodyDecoder.decodeRequest(apiKey, apiVersion, accessor);
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: body {}", (Object)ctx, (Object)body);
            }
            frame = new DecodedRequestFrame<ApiMessage>(apiVersion, correlationId, decodeResponse, header, body);
            if (this.log().isTraceEnabled()) {
                this.log().trace("{}: frame {}", (Object)ctx, (Object)frame);
            }
        } else {
            boolean hasResponse = true;
            if (apiKey == ApiKeys.PRODUCE) {
                short acks = KafkaRequestDecoder.readAcks(in, startOfMessage, apiKey.id, apiVersion);
                hasResponse = acks != 0;
            }
            in.readerIndex(sof);
            frame = this.opaqueFrame(in, correlationId, decodeResponse, length, hasResponse);
            in.readerIndex(sof + length);
        }
        return frame;
    }

    private static void incrementReaderIndex(ByteBuf byteBuf, int increment) {
        byteBuf.readerIndex(byteBuf.readerIndex() + increment);
    }

    static short readAcks(ByteBuf in, int startOfMessage, short apiKey, short apiVersion) {
        in.readerIndex(startOfMessage);
        short headerVersion = ApiKeys.forId((int)apiKey).requestHeaderVersion(apiVersion);
        KafkaRequestDecoder.incrementReaderIndex(in, 4);
        if (headerVersion >= 1) {
            short clientIdLength = in.readShort();
            KafkaRequestDecoder.incrementReaderIndex(in, clientIdLength);
        }
        if (headerVersion >= 2) {
            int numTaggedFields = ByteBufAccessorImpl.readUnsignedVarint(in);
            for (int i = 0; i < numTaggedFields; ++i) {
                ByteBufAccessorImpl.readUnsignedVarint(in);
                int size = ByteBufAccessorImpl.readUnsignedVarint(in);
                KafkaRequestDecoder.incrementReaderIndex(in, size);
            }
        }
        if (apiVersion >= 3) {
            int transactionIdLength;
            if (apiVersion < 9) {
                transactionIdLength = in.readShort();
            } else if (apiVersion <= 11) {
                transactionIdLength = ByteBufAccessorImpl.readUnsignedVarint(in);
            } else {
                throw new AssertionError((Object)("Unsupported Produce apiVersion: " + apiVersion));
            }
            KafkaRequestDecoder.incrementReaderIndex(in, transactionIdLength);
        }
        short acks = in.readShort();
        return acks;
    }

    private OpaqueRequestFrame opaqueFrame(ByteBuf in, int correlationId, boolean decodeResponse, int length, boolean hasResponse) {
        return new OpaqueRequestFrame(in.readSlice(length).retain(), correlationId, decodeResponse, length, hasResponse);
    }

    private RequestHeaderData readHeader(short headerVersion, Readable accessor) {
        return new RequestHeaderData(accessor, headerVersion);
    }
}

