/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.codec;

import io.kroxylicious.proxy.filter.Filter;
import io.kroxylicious.proxy.frame.DecodedResponseFrame;
import io.kroxylicious.proxy.frame.Frame;
import io.kroxylicious.proxy.frame.OpaqueFrame;
import io.kroxylicious.proxy.frame.OpaqueResponseFrame;
import io.kroxylicious.proxy.internal.InternalResponseFrame;
import io.kroxylicious.proxy.internal.codec.BodyDecoder;
import io.kroxylicious.proxy.internal.codec.ByteBufAccessorImpl;
import io.kroxylicious.proxy.internal.codec.CorrelationManager;
import io.kroxylicious.proxy.internal.codec.KafkaMessageDecoder;
import io.kroxylicious.proxy.internal.util.Metrics;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaResponseDecoder
extends KafkaMessageDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaResponseDecoder.class);
    private final CorrelationManager correlationManager;

    public KafkaResponseDecoder(CorrelationManager correlationManager, int socketRequestMaxSizeBytes) {
        super(socketRequestMaxSizeBytes);
        this.correlationManager = correlationManager;
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }

    @Override
    protected Frame decodeHeaderAndBody(ChannelHandlerContext ctx, ByteBuf in, int length) {
        Frame frame;
        int wi = in.writerIndex();
        int ri = in.readerIndex();
        int upstreamCorrelationId = in.readInt();
        in.readerIndex(ri);
        CorrelationManager.Correlation correlation = this.correlationManager.getBrokerCorrelation(upstreamCorrelationId);
        if (correlation == null) {
            throw new AssertionError((Object)("Missing correlation id " + upstreamCorrelationId));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}: Recovered correlation {} for upstream correlation id {}", new Object[]{ctx, correlation, upstreamCorrelationId});
        }
        int correlationId = correlation.downstreamCorrelationId();
        in.writerIndex(ri);
        in.writeInt(correlationId);
        in.writerIndex(wi);
        if (correlation.decodeResponse()) {
            ApiKeys apiKey = ApiKeys.forId((int)correlation.apiKey());
            short apiVersion = correlation.apiVersion();
            ByteBufAccessorImpl accessor = new ByteBufAccessorImpl(in);
            short headerVersion = apiKey.responseHeaderVersion(apiVersion);
            this.log().trace("{}: Header version: {}", (Object)ctx, (Object)headerVersion);
            ResponseHeaderData header = this.readHeader(headerVersion, accessor);
            this.log().trace("{}: Header: {}", (Object)ctx, (Object)header);
            ApiMessage body = BodyDecoder.decodeResponse(apiKey, apiVersion, accessor);
            this.log().trace("{}: Body: {}", (Object)ctx, (Object)body);
            Filter recipient = correlation.recipient();
            Metrics.payloadSizeBytesDownstreamSummary(apiKey, apiVersion).record((double)length);
            frame = recipient == null ? new DecodedResponseFrame<ApiMessage>(apiVersion, correlationId, header, body) : new InternalResponseFrame<ApiMessage>(recipient, apiVersion, correlationId, header, body, correlation.promise());
        } else {
            frame = this.opaqueFrame(in, correlationId, length);
        }
        this.log().trace("{}: Frame: {}", (Object)ctx, (Object)frame);
        return frame;
    }

    private OpaqueFrame opaqueFrame(ByteBuf in, int correlationId, int length) {
        return new OpaqueResponseFrame(in.readSlice(length).retain(), correlationId, length);
    }

    private ResponseHeaderData readHeader(short headerVersion, Readable accessor) {
        return new ResponseHeaderData(accessor, headerVersion);
    }
}

