/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.filter;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.kroxylicious.proxy.filter.FilterResult;
import io.kroxylicious.proxy.filter.FilterResultBuilder;
import io.kroxylicious.proxy.filter.filterresultbuilder.CloseOrTerminalStage;
import io.kroxylicious.proxy.filter.filterresultbuilder.TerminalStage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.kafka.common.protocol.ApiMessage;

public abstract class FilterResultBuilderImpl<H extends ApiMessage, R extends FilterResult>
implements FilterResultBuilder<H, R>,
CloseOrTerminalStage<R> {
    private ApiMessage message;
    private ApiMessage header;
    private boolean closeConnection;
    private boolean drop;

    protected FilterResultBuilderImpl() {
    }

    public CloseOrTerminalStage<R> forward(@NonNull H header, @NonNull ApiMessage message) {
        this.validateForward(header, message);
        this.header = header;
        this.message = message;
        return this;
    }

    protected void validateForward(H header, ApiMessage message) {
        if (header == null) {
            throw new IllegalArgumentException("header may not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message may not be null");
        }
    }

    ApiMessage header() {
        return this.header;
    }

    ApiMessage message() {
        return this.message;
    }

    public TerminalStage<R> withCloseConnection() {
        this.closeConnection = true;
        return this;
    }

    boolean closeConnection() {
        return this.closeConnection;
    }

    public TerminalStage<R> drop() {
        this.drop = true;
        return this;
    }

    public boolean isDrop() {
        return this.drop;
    }

    public CompletionStage<R> completed() {
        return CompletableFuture.completedStage(this.build());
    }
}

