/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.filter;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.filter.RequestFilterResult;
import io.kroxylicious.proxy.filter.RequestFilterResultBuilder;
import io.kroxylicious.proxy.filter.filterresultbuilder.CloseOrTerminalStage;
import io.kroxylicious.proxy.internal.filter.FilterResultBuilderImpl;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiMessage;

public class RequestFilterResultBuilderImpl
extends FilterResultBuilderImpl<RequestHeaderData, RequestFilterResult>
implements RequestFilterResultBuilder {
    private static final String REQUEST_DATA_NAME_SUFFIX = "RequestData";
    private static final String RESPONSE_DATA_NAME_SUFFIX = "ResponseData";
    private ResponseHeaderData shortCircuitHeader;
    private ApiMessage shortCircuitResponse;

    @Override
    protected void validateForward(RequestHeaderData header, ApiMessage message) {
        super.validateForward(header, message);
        if (message != null && !message.getClass().getSimpleName().endsWith(REQUEST_DATA_NAME_SUFFIX)) {
            throw new IllegalArgumentException("class name " + message.getClass().getName() + " does not have expected suffix RequestData");
        }
    }

    public CloseOrTerminalStage<RequestFilterResult> shortCircuitResponse(@Nullable ResponseHeaderData header, @NonNull ApiMessage message) {
        this.validateShortCircuitResponse(message);
        this.shortCircuitHeader = header;
        this.shortCircuitResponse = message;
        return this;
    }

    public CloseOrTerminalStage<RequestFilterResult> shortCircuitResponse(@NonNull ApiMessage message) {
        this.validateShortCircuitResponse(message);
        this.shortCircuitResponse = message;
        return this;
    }

    private void validateShortCircuitResponse(ApiMessage message) {
        if (message == null) {
            throw new IllegalArgumentException("message may not be null");
        }
        if (!message.getClass().getSimpleName().endsWith(RESPONSE_DATA_NAME_SUFFIX)) {
            throw new IllegalArgumentException("class name " + message.getClass().getName() + " does not have expected suffix ResponseData");
        }
    }

    public RequestFilterResult build() {
        return new RequestFilterResult(){

            public boolean shortCircuitResponse() {
                return RequestFilterResultBuilderImpl.this.shortCircuitResponse != null;
            }

            public ApiMessage header() {
                return RequestFilterResultBuilderImpl.this.shortCircuitResponse == null ? RequestFilterResultBuilderImpl.this.header() : RequestFilterResultBuilderImpl.this.shortCircuitHeader;
            }

            public ApiMessage message() {
                return RequestFilterResultBuilderImpl.this.shortCircuitResponse == null ? RequestFilterResultBuilderImpl.this.message() : RequestFilterResultBuilderImpl.this.shortCircuitResponse;
            }

            public boolean closeConnection() {
                return RequestFilterResultBuilderImpl.this.closeConnection();
            }

            public boolean drop() {
                return RequestFilterResultBuilderImpl.this.isDrop();
            }
        };
    }
}

