/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.filter;

import io.kroxylicious.proxy.filter.ResponseFilterResult;
import io.kroxylicious.proxy.filter.ResponseFilterResultBuilder;
import io.kroxylicious.proxy.internal.filter.FilterResultBuilderImpl;
import org.apache.kafka.common.message.ResponseHeaderData;
import org.apache.kafka.common.protocol.ApiMessage;

public class ResponseFilterResultBuilderImpl
extends FilterResultBuilderImpl<ResponseHeaderData, ResponseFilterResult>
implements ResponseFilterResultBuilder {
    private static final String RESPONSE_DATA_NAME_SUFFIX = "ResponseData";

    @Override
    protected void validateForward(ResponseHeaderData header, ApiMessage message) {
        super.validateForward(header, message);
        if (message != null && !message.getClass().getSimpleName().endsWith(RESPONSE_DATA_NAME_SUFFIX)) {
            throw new IllegalArgumentException("class name " + message.getClass().getName() + " does not have expected suffix ResponseData");
        }
    }

    public ResponseFilterResult build() {
        return new ResponseFilterResult(){

            public ApiMessage header() {
                return ResponseFilterResultBuilderImpl.this.header();
            }

            public ApiMessage message() {
                return ResponseFilterResultBuilderImpl.this.message();
            }

            public boolean closeConnection() {
                return ResponseFilterResultBuilderImpl.this.closeConnection();
            }

            public boolean drop() {
                return ResponseFilterResultBuilderImpl.this.isDrop();
            }
        };
    }
}

