/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.net;

import io.kroxylicious.proxy.internal.net.NetworkBindingOperation;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUnbindRequest
extends NetworkBindingOperation<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkUnbindRequest.class);
    private final Channel channel;
    private final CompletableFuture<Void> future;

    public NetworkUnbindRequest(boolean tls, Channel channel, CompletableFuture<Void> future) {
        super(tls);
        this.channel = channel;
        this.future = future;
    }

    @Override
    public int port() {
        return ((InetSocketAddress)this.channel.localAddress()).getPort();
    }

    @Override
    public void performBindingOperation(ServerBootstrap serverBootstrap, ExecutorService executorService) {
        try {
            SocketAddress addr = this.channel.localAddress();
            LOGGER.info("Unbinding {}", (Object)addr);
            this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> executorService.execute(() -> {
                if (channelFuture.cause() != null) {
                    LOGGER.debug("Unbind failed {}", (Object)addr, (Object)channelFuture.cause());
                    this.future.completeExceptionally(channelFuture.cause());
                } else {
                    LOGGER.info("Unbound {}", (Object)addr);
                    this.future.complete(null);
                }
            })));
        }
        catch (Throwable t) {
            this.future.completeExceptionally(t);
        }
    }

    @Override
    public CompletableFuture<Void> getFuture() {
        return this.future;
    }
}

