/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.util;

import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.ByteBufferOutputStream;

public class MemoryRecordsHelper {
    private MemoryRecordsHelper() {
    }

    public static MemoryRecordsBuilder builder(ByteBufferOutputStream stream, Compression compression, TimestampType timestampType, long baseOffset) {
        return MemoryRecordsHelper.builder(stream, (byte)2, compression, timestampType, baseOffset);
    }

    private static MemoryRecordsBuilder builder(ByteBufferOutputStream stream, byte magic, Compression compression, TimestampType timestampType, long baseOffset) {
        long logAppendTime = -1L;
        if (timestampType == TimestampType.LOG_APPEND_TIME) {
            logAppendTime = System.currentTimeMillis();
        }
        return MemoryRecordsHelper.builder(stream, magic, compression, timestampType, baseOffset, logAppendTime, -1L, (short)-1, -1, false, -1);
    }

    private static MemoryRecordsBuilder builder(ByteBufferOutputStream stream, byte magic, Compression compression, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, int partitionLeaderEpoch) {
        return MemoryRecordsHelper.builder(stream, magic, compression, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, false, partitionLeaderEpoch);
    }

    private static MemoryRecordsBuilder builder(ByteBufferOutputStream stream, byte magic, Compression compression, TimestampType timestampType, long baseOffset, long logAppendTime, long producerId, short producerEpoch, int baseSequence, boolean isTransactional, boolean isControlBatch, int partitionLeaderEpoch) {
        return new MemoryRecordsBuilder(stream, magic, compression, timestampType, baseOffset, logAppendTime, producerId, producerEpoch, baseSequence, isTransactional, isControlBatch, partitionLeaderEpoch, stream.remaining());
    }
}

