/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.internal.util;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Tag;
import java.util.List;
import org.apache.kafka.common.protocol.ApiKeys;

public class Metrics {
    private static final String KROXYLICIOUS_INBOUND_DOWNSTREAM_MESSAGES = "kroxylicious_inbound_downstream_messages";
    private static final String KROXYLICIOUS_INBOUND_DOWNSTREAM_DECODED_MESSAGES = "kroxylicious_inbound_downstream_decoded_messages";
    private static final String KROXYLICIOUS_PAYLOAD_SIZE_BYTES = "kroxylicious_payload_size_bytes";
    private static final String FLOWING_TAG = "flowing";
    private static final Tag FLOWING_UPSTREAM = Tag.of((String)"flowing", (String)"upstream");
    private static final Tag FLOWING_DOWNSTREAM = Tag.of((String)"flowing", (String)"downstream");

    public static Counter inboundDownstreamMessagesCounter() {
        return io.micrometer.core.instrument.Metrics.counter((String)KROXYLICIOUS_INBOUND_DOWNSTREAM_MESSAGES, List.of(FLOWING_DOWNSTREAM));
    }

    public static Counter inboundDownstreamDecodedMessagesCounter() {
        return io.micrometer.core.instrument.Metrics.counter((String)KROXYLICIOUS_INBOUND_DOWNSTREAM_DECODED_MESSAGES, List.of(FLOWING_DOWNSTREAM));
    }

    public static DistributionSummary payloadSizeBytesUpstreamSummary(ApiKeys apiKey, short apiVersion) {
        return Metrics.payloadSizeBytesSummary(apiKey, apiVersion, FLOWING_UPSTREAM);
    }

    public static DistributionSummary payloadSizeBytesDownstreamSummary(ApiKeys apiKey, short apiVersion) {
        return Metrics.payloadSizeBytesSummary(apiKey, apiVersion, FLOWING_DOWNSTREAM);
    }

    private static DistributionSummary payloadSizeBytesSummary(ApiKeys apiKey, short apiVersion, Tag flowing) {
        List<Tag> tags = List.of(Tag.of((String)"ApiKey", (String)apiKey.name()), Tag.of((String)"ApiVersion", (String)String.valueOf(apiVersion)), flowing);
        return io.micrometer.core.instrument.Metrics.summary((String)KROXYLICIOUS_PAYLOAD_SIZE_BYTES, tags);
    }
}

