/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.model;

import io.kroxylicious.proxy.config.TargetCluster;
import io.kroxylicious.proxy.config.tls.NettyKeyProvider;
import io.kroxylicious.proxy.config.tls.NettyTrustProvider;
import io.kroxylicious.proxy.config.tls.PlatformTrustProvider;
import io.kroxylicious.proxy.config.tls.Tls;
import io.kroxylicious.proxy.config.tls.TrustProvider;
import io.kroxylicious.proxy.service.ClusterNetworkAddressConfigProvider;
import io.kroxylicious.proxy.service.HostPort;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualCluster
implements ClusterNetworkAddressConfigProvider {
    public static final int DEFAULT_SOCKET_FRAME_MAX_SIZE_BYTES = 0x6400000;
    private final String clusterName;
    private final TargetCluster targetCluster;
    private final Optional<Tls> tls;
    private final boolean logNetwork;
    private final boolean logFrames;
    private final ClusterNetworkAddressConfigProvider clusterNetworkAddressConfigProvider;
    private final Optional<SslContext> upstreamSslContext;
    private final Optional<SslContext> downstreamSslContext;
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualCluster.class);

    public VirtualCluster(String clusterName, TargetCluster targetCluster, ClusterNetworkAddressConfigProvider clusterNetworkAddressConfigProvider, Optional<Tls> tls, boolean logNetwork, boolean logFrames) {
        this.clusterName = clusterName;
        this.tls = tls;
        this.targetCluster = targetCluster;
        this.logNetwork = logNetwork;
        this.logFrames = logFrames;
        this.clusterNetworkAddressConfigProvider = clusterNetworkAddressConfigProvider;
        VirtualCluster.validateTLsSettings(clusterNetworkAddressConfigProvider, tls);
        VirtualCluster.validatePortUsage(clusterNetworkAddressConfigProvider);
        this.upstreamSslContext = this.buildUpstreamSslContext();
        this.downstreamSslContext = this.buildDownstreamSslContext();
        VirtualCluster.logVirtualClusterSummary(clusterName, targetCluster, clusterNetworkAddressConfigProvider, tls);
    }

    private static void logVirtualClusterSummary(String clusterName, TargetCluster targetCluster, ClusterNetworkAddressConfigProvider clusterNetworkAddressConfigProvider, Optional<Tls> tls) {
        try {
            String downstreamTls = tls.map(tls1 -> " (TLS)").orElse("");
            HostPort downstreamBootstrap = clusterNetworkAddressConfigProvider.getClusterBootstrapAddress();
            String upstreamTls = targetCluster.tls().map(tls1 -> " (TLS)").orElse("");
            HostPort upstreamHostPort = targetCluster.bootstrapServersList().get(0);
            LOGGER.info("Virtual Cluster: {}, Downstream {}{} => Upstream {}{}", new Object[]{clusterName, downstreamBootstrap, downstreamTls, upstreamHostPort, upstreamTls});
        }
        catch (Exception e) {
            LOGGER.warn("Failed to log summary for Virtual Cluster: {}", (Object)clusterName, (Object)e);
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public TargetCluster targetCluster() {
        return this.targetCluster;
    }

    public ClusterNetworkAddressConfigProvider getClusterNetworkAddressConfigProvider() {
        return this.clusterNetworkAddressConfigProvider;
    }

    public boolean isLogNetwork() {
        return this.logNetwork;
    }

    public boolean isLogFrames() {
        return this.logFrames;
    }

    public boolean isUseTls() {
        return this.tls.isPresent();
    }

    public int socketFrameMaxSizeBytes() {
        return 0x6400000;
    }

    public String toString() {
        return "VirtualCluster{clusterName='" + this.clusterName + "', targetCluster=" + String.valueOf(this.targetCluster) + ", tls=" + String.valueOf(this.tls) + ", logNetwork=" + this.logNetwork + ", logFrames=" + this.logFrames + ", clusterNetworkAddressConfigProvider=" + String.valueOf(this.clusterNetworkAddressConfigProvider) + ", upstreamSslContext=" + String.valueOf(this.upstreamSslContext) + ", downstreamSslContext=" + String.valueOf(this.downstreamSslContext) + "}";
    }

    @Override
    public HostPort getClusterBootstrapAddress() {
        return this.clusterNetworkAddressConfigProvider.getClusterBootstrapAddress();
    }

    @Override
    public HostPort getBrokerAddress(int nodeId) throws IllegalArgumentException {
        return this.clusterNetworkAddressConfigProvider.getBrokerAddress(nodeId);
    }

    @Override
    public Optional<String> getBindAddress() {
        return this.clusterNetworkAddressConfigProvider.getBindAddress();
    }

    @Override
    public boolean requiresTls() {
        return this.clusterNetworkAddressConfigProvider.requiresTls();
    }

    @Override
    public Set<Integer> getExclusivePorts() {
        return this.clusterNetworkAddressConfigProvider.getExclusivePorts();
    }

    @Override
    public Set<Integer> getSharedPorts() {
        return this.clusterNetworkAddressConfigProvider.getSharedPorts();
    }

    @Override
    public Map<Integer, HostPort> discoveryAddressMap() {
        return this.clusterNetworkAddressConfigProvider.discoveryAddressMap();
    }

    @Override
    public Integer getBrokerIdFromBrokerAddress(HostPort brokerAddress) {
        return this.clusterNetworkAddressConfigProvider.getBrokerIdFromBrokerAddress(brokerAddress);
    }

    public Optional<SslContext> getDownstreamSslContext() {
        return this.downstreamSslContext;
    }

    public Optional<SslContext> getUpstreamSslContext() {
        return this.upstreamSslContext;
    }

    private Optional<SslContext> buildDownstreamSslContext() {
        return this.tls.map(tlsConfiguration -> {
            try {
                return Optional.of(tlsConfiguration.key()).map(NettyKeyProvider::new).map(NettyKeyProvider::forServer).orElseThrow().build();
            }
            catch (SSLException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private Optional<SslContext> buildUpstreamSslContext() {
        return this.targetCluster.tls().map(targetClusterTls -> {
            try {
                SslContextBuilder sslContextBuilder = Optional.ofNullable(targetClusterTls.key()).map(NettyKeyProvider::new).map(NettyKeyProvider::forClient).orElse(SslContextBuilder.forClient());
                TrustProvider trustProvider = Optional.ofNullable(targetClusterTls.trust()).orElse((TrustProvider)PlatformTrustProvider.INSTANCE);
                SslContextBuilder withTrust = new NettyTrustProvider(trustProvider).apply(sslContextBuilder);
                return withTrust.build();
            }
            catch (SSLException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static void validatePortUsage(ClusterNetworkAddressConfigProvider clusterNetworkAddressConfigProvider) {
        Set conflicts = clusterNetworkAddressConfigProvider.getExclusivePorts().stream().filter(p -> clusterNetworkAddressConfigProvider.getSharedPorts().contains(p)).collect(Collectors.toSet());
        if (!conflicts.isEmpty()) {
            throw new IllegalStateException("The set of exclusive ports described by the cluster endpoint provider must be distinct from those described as shared. Intersection: " + String.valueOf(conflicts));
        }
    }

    private static void validateTLsSettings(ClusterNetworkAddressConfigProvider clusterNetworkAddressConfigProvider, Optional<Tls> tls) {
        if (clusterNetworkAddressConfigProvider.requiresTls() && (tls.isEmpty() || !tls.get().definesKey())) {
            throw new IllegalStateException("Cluster endpoint provider requires server TLS, but this virtual cluster does not define it.");
        }
    }
}

