/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.service;

import io.kroxylicious.proxy.service.Context;
import io.kroxylicious.proxy.service.Contributor;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

@Deprecated(since="0.3.0", forRemoval=true)
public class ContributionManager {
    public static final ContributionManager INSTANCE = new ContributionManager();
    private final Map<Class, Iterable> contributors = new ConcurrentHashMap<Class, Iterable>();
    private final Function<Class, Iterable> loaderFunction;

    private ContributionManager() {
        this(ServiceLoader::load);
    }

    ContributionManager(Function<Class, Iterable> loaderFunction) {
        this.loaderFunction = loaderFunction;
    }

    public <S extends Contributor> ConfigurationDefinition getDefinition(Class<S> contributorClass, String typeName) {
        return this.findContributor(contributorClass, typeName, s -> new ConfigurationDefinition(s.getConfigType(), s.requiresConfiguration()));
    }

    public <T, S extends Contributor> T createInstance(Class<S> contributorClass, String typeName, Context constructionContext) {
        return (T)this.findContributor(contributorClass, typeName, contributor -> contributor.createInstance(constructionContext));
    }

    private <T, S extends Contributor<T, ?, ?>, X> X findContributor(Class<S> contributorClass, String typeName, Function<S, X> extractor) {
        Iterable contributorsForClass = this.contributors.computeIfAbsent(contributorClass, this.loaderFunction);
        for (Contributor contributor : contributorsForClass) {
            if (!ContributionManager.matches(typeName, contributor)) continue;
            return extractor.apply(contributor);
        }
        throw new IllegalArgumentException("Name '" + typeName + "' is not contributed by any " + String.valueOf(contributorClass));
    }

    private static <T, S extends Contributor<T, ?, ?>> boolean matches(String typeName, S contributor) {
        Class<T> contributorClass = contributor.getServiceType();
        boolean matchesShortNameForTopLevelClass = !contributorClass.isMemberClass() && !contributorClass.isLocalClass() && !contributorClass.isAnonymousClass() && contributorClass.getSimpleName().equals(typeName);
        return contributorClass.getName().equals(typeName) || matchesShortNameForTopLevelClass;
    }

    public record ConfigurationDefinition(Class<?> configurationType, boolean configurationRequired) {
    }
}

