/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.service;

import com.fasterxml.jackson.annotation.JsonCreator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HostPort {
    private static final Pattern IPV6_WITH_PORT = Pattern.compile("^(\\[.+]):(.+)$");
    private static final Pattern PORT_SEPARATOR = Pattern.compile(":");
    private final String host;
    private final int port;
    private final int hash;

    public HostPort(@NonNull String host, int port) {
        Objects.requireNonNull(host, "host cannot be null");
        this.host = host;
        this.port = port;
        this.hash = Objects.hash(host.toLowerCase(Locale.ROOT), port);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HostPort that = (HostPort)obj;
        return this.host.equalsIgnoreCase(that.host) && this.port == that.port;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    @JsonCreator
    public static HostPort parse(@NonNull String address) {
        String exceptionText = "unexpected address formation '%s'. Valid formations are 'host:9092', 'host.example.com:9092', or '[::ffff:c0a8:1]:9092', ".formatted(address);
        if (address == null) {
            throw new IllegalArgumentException(exceptionText);
        }
        Matcher ipv6Match = IPV6_WITH_PORT.matcher(address);
        if (ipv6Match.matches()) {
            String host = ipv6Match.group(1);
            int port = HostPort.parsePort(exceptionText, ipv6Match.group(2));
            return new HostPort(host, port);
        }
        String[] split = PORT_SEPARATOR.split(address);
        if (split.length != 2) {
            throw new IllegalArgumentException(exceptionText);
        }
        String host = split[0];
        if (host.isEmpty() || host.isBlank()) {
            throw new IllegalArgumentException(exceptionText);
        }
        int port = HostPort.parsePort(exceptionText, split[1]);
        return new HostPort(host, port);
    }

    private static int parsePort(String exceptionText, String group) {
        try {
            return Integer.parseInt(group);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(exceptionText, nfe);
        }
    }
}

