/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.metrics.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.JvmAttributeGaugeSet;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import io.ktor.application.Application;
import io.ktor.application.ApplicationCall;
import io.ktor.application.ApplicationCallPipeline;
import io.ktor.application.ApplicationFeature;
import io.ktor.http.HttpStatusCode;
import io.ktor.routing.Routing;
import io.ktor.routing.RoutingApplicationCall;
import io.ktor.util.AttributeKey;
import io.ktor.util.Attributes;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelinePhase;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0003 !\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \t*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics;", "", "registry", "Lcom/codahale/metrics/MetricRegistry;", "baseName", "", "(Lcom/codahale/metrics/MetricRegistry;Ljava/lang/String;)V", "active", "Lcom/codahale/metrics/Counter;", "kotlin.jvm.PlatformType", "getBaseName", "()Ljava/lang/String;", "duration", "Lcom/codahale/metrics/Timer;", "exceptions", "Lcom/codahale/metrics/Meter;", "httpStatus", "Ljava/util/concurrent/ConcurrentHashMap;", "", "measureKey", "Lio/ktor/util/AttributeKey;", "Lio/ktor/metrics/dropwizard/DropwizardMetrics$CallMeasure;", "getRegistry", "()Lcom/codahale/metrics/MetricRegistry;", "after", "", "call", "Lio/ktor/application/ApplicationCall;", "before", "exception", "e", "", "CallMeasure", "Configuration", "Feature", "ktor-metrics"})
public final class DropwizardMetrics {
    private final Timer duration;
    private final Counter active;
    private final Meter exceptions;
    private final ConcurrentHashMap<Integer, Meter> httpStatus;
    private final AttributeKey<CallMeasure> measureKey;
    @NotNull
    private final MetricRegistry registry;
    @NotNull
    private final String baseName;
    @NotNull
    private static final AttributeKey<DropwizardMetrics> key;
    private static final AttributeKey<Feature.RoutingMetrics> routingMetricsKey;
    public static final Feature Feature;

    private final void before(ApplicationCall call) {
        this.active.inc();
        Attributes attributes = call.getAttributes();
        Timer.Context context = this.duration.time();
        Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"duration.time()");
        attributes.put(this.measureKey, (Object)new CallMeasure(context));
    }

    private final void after(ApplicationCall call) {
        block0: {
            this.active.dec();
            HttpStatusCode httpStatusCode = call.getResponse().status();
            Meter meter2 = this.httpStatus.computeIfAbsent(httpStatusCode != null ? httpStatusCode.getValue() : 0, new Function<Integer, Meter>(this){
                final /* synthetic */ DropwizardMetrics this$0;

                public final Meter apply(@NotNull Integer it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return this.this$0.getRegistry().meter(MetricRegistry.name((String)this.this$0.getBaseName(), (String[])new String[]{"status", String.valueOf(it)}));
                }
                {
                    this.this$0 = dropwizardMetrics;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)meter2, (String)"httpStatus.computeIfAbse\u2026it.toString()))\n        }");
            Meter meter3 = meter2;
            meter3.mark();
            CallMeasure callMeasure = (CallMeasure)call.getAttributes().getOrNull(this.measureKey);
            if (callMeasure == null) break block0;
            CallMeasure callMeasure2 = callMeasure;
            boolean bl = false;
            boolean bl2 = false;
            CallMeasure $this$apply = callMeasure2;
            boolean bl3 = false;
            $this$apply.getTimer().stop();
        }
    }

    private final void exception(ApplicationCall call, Throwable e) {
        this.exceptions.mark();
    }

    @NotNull
    public final MetricRegistry getRegistry() {
        return this.registry;
    }

    @NotNull
    public final String getBaseName() {
        return this.baseName;
    }

    public DropwizardMetrics(@NotNull MetricRegistry registry, @NotNull String baseName) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        Intrinsics.checkParameterIsNotNull((Object)baseName, (String)"baseName");
        this.registry = registry;
        this.baseName = baseName;
        this.duration = this.registry.timer(MetricRegistry.name((String)this.baseName, (String[])new String[]{"duration"}));
        this.active = this.registry.counter(MetricRegistry.name((String)this.baseName, (String[])new String[]{"active"}));
        this.exceptions = this.registry.meter(MetricRegistry.name((String)this.baseName, (String[])new String[]{"exceptions"}));
        this.httpStatus = new ConcurrentHashMap();
        this.measureKey = new AttributeKey("metrics");
    }

    public /* synthetic */ DropwizardMetrics(MetricRegistry metricRegistry, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            String string2 = MetricRegistry.name((String)"ktor.calls", (String[])new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MetricRegistry.name(\"ktor.calls\")");
            string = string2;
        }
        this(metricRegistry, string);
    }

    static {
        Feature = new Feature(null);
        key = new AttributeKey("metrics");
        routingMetricsKey = new AttributeKey("metrics");
    }

    public static final /* synthetic */ void access$before(DropwizardMetrics $this, ApplicationCall call) {
        $this.before(call);
    }

    public static final /* synthetic */ void access$after(DropwizardMetrics $this, ApplicationCall call) {
        $this.after(call);
    }

    public static final /* synthetic */ void access$exception(DropwizardMetrics $this, ApplicationCall call, Throwable e) {
        $this.exception(call, e);
    }

    public static final /* synthetic */ AttributeKey access$getRoutingMetricsKey$cp() {
        return routingMetricsKey;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$Configuration;", "", "()V", "baseName", "", "getBaseName", "()Ljava/lang/String;", "setBaseName", "(Ljava/lang/String;)V", "registry", "Lcom/codahale/metrics/MetricRegistry;", "getRegistry", "()Lcom/codahale/metrics/MetricRegistry;", "setRegistry", "(Lcom/codahale/metrics/MetricRegistry;)V", "ktor-metrics"})
    public static final class Configuration {
        @NotNull
        private String baseName;
        @NotNull
        private MetricRegistry registry;

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        public final void setBaseName(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.baseName = string;
        }

        @NotNull
        public final MetricRegistry getRegistry() {
            return this.registry;
        }

        public final void setRegistry(@NotNull MetricRegistry metricRegistry) {
            Intrinsics.checkParameterIsNotNull((Object)metricRegistry, (String)"<set-?>");
            this.registry = metricRegistry;
        }

        public Configuration() {
            String string = MetricRegistry.name((String)"ktor.calls", (String[])new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MetricRegistry.name(\"ktor.calls\")");
            this.baseName = string;
            this.registry = new MetricRegistry();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$CallMeasure;", "", "timer", "Lcom/codahale/metrics/Timer$Context;", "(Lcom/codahale/metrics/Timer$Context;)V", "getTimer", "()Lcom/codahale/metrics/Timer$Context;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ktor-metrics"})
    private static final class CallMeasure {
        @NotNull
        private final Timer.Context timer;

        @NotNull
        public final Timer.Context getTimer() {
            return this.timer;
        }

        public CallMeasure(@NotNull Timer.Context timer) {
            Intrinsics.checkParameterIsNotNull((Object)timer, (String)"timer");
            this.timer = timer;
        }

        @NotNull
        public final Timer.Context component1() {
            return this.timer;
        }

        @NotNull
        public final CallMeasure copy(@NotNull Timer.Context timer) {
            Intrinsics.checkParameterIsNotNull((Object)timer, (String)"timer");
            return new CallMeasure(timer);
        }

        @NotNull
        public static /* synthetic */ CallMeasure copy$default(CallMeasure callMeasure, Timer.Context context, int n, Object object) {
            if ((n & 1) != 0) {
                context = callMeasure.timer;
            }
            return callMeasure.copy(context);
        }

        @NotNull
        public String toString() {
            return "CallMeasure(timer=" + this.timer + ")";
        }

        public int hashCode() {
            Timer.Context context = this.timer;
            return context != null ? context.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CallMeasure)) break block3;
                    CallMeasure callMeasure = (CallMeasure)object;
                    if (!Intrinsics.areEqual((Object)this.timer, (Object)callMeasure.timer)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J)\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00022\u0017\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\b\u0011H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$Feature;", "Lio/ktor/application/ApplicationFeature;", "Lio/ktor/application/Application;", "Lio/ktor/metrics/dropwizard/DropwizardMetrics$Configuration;", "Lio/ktor/metrics/dropwizard/DropwizardMetrics;", "()V", "key", "Lio/ktor/util/AttributeKey;", "getKey", "()Lio/ktor/util/AttributeKey;", "routingMetricsKey", "Lio/ktor/metrics/dropwizard/DropwizardMetrics$Feature$RoutingMetrics;", "install", "pipeline", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "RoutingMetrics", "ktor-metrics"})
    public static final class Feature
    implements ApplicationFeature<Application, Configuration, DropwizardMetrics> {
        @NotNull
        public AttributeKey<DropwizardMetrics> getKey() {
            return key;
        }

        @NotNull
        public DropwizardMetrics install(@NotNull Application pipeline, @NotNull Function1<? super Configuration, Unit> configure) {
            Intrinsics.checkParameterIsNotNull((Object)pipeline, (String)"pipeline");
            Intrinsics.checkParameterIsNotNull(configure, (String)"configure");
            Configuration configuration = new Configuration();
            boolean bl = false;
            boolean bl2 = false;
            configure.invoke((Object)configuration);
            Configuration configuration2 = configuration;
            DropwizardMetrics feature = new DropwizardMetrics(configuration2.getRegistry(), configuration2.getBaseName());
            configuration2.getRegistry().register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
            configuration2.getRegistry().register("jvm.garbage", (Metric)new GarbageCollectorMetricSet());
            configuration2.getRegistry().register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
            configuration2.getRegistry().register("jvm.files", (Metric)new FileDescriptorRatioGauge());
            configuration2.getRegistry().register("jvm.attributes", (Metric)new JvmAttributeGaugeSet());
            PipelinePhase phase = new PipelinePhase("DropwizardMetrics");
            pipeline.insertPhaseBefore(ApplicationCallPipeline.ApplicationPhase.getMonitoring(), phase);
            pipeline.intercept(phase, (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(feature, null){
                private PipelineContext p$;
                private Unit p$0;
                Object L$0;
                int label;
                final /* synthetic */ DropwizardMetrics $feature;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            PipelineContext $this$call$iv;
                            ResultKt.throwOnFailure((Object)result);
                            PipelineContext pipelineContext = this.p$;
                            Unit unit = this.p$0;
                            PipelineContext pipelineContext2 = pipelineContext;
                            DropwizardMetrics dropwizardMetrics = this.$feature;
                            boolean $i$f$getCall = false;
                            ApplicationCall applicationCall = (ApplicationCall)$this$call$iv.getContext();
                            DropwizardMetrics.access$before(dropwizardMetrics, applicationCall);
                            this.L$0 = pipelineContext;
                            this.label = 1;
                            Object object2 = pipelineContext.proceed((Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object2;
                            ApplicationCall applicationCall;
                            DropwizardMetrics dropwizardMetrics;
                            PipelineContext pipelineContext = (PipelineContext)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)result);
                                object2 = result;
                                return Unit.INSTANCE;
                            }
                            catch (Exception e) {
                                void $this$call$iv;
                                PipelineContext $i$f$getCall = pipelineContext;
                                dropwizardMetrics = this.$feature;
                                boolean $i$f$getCall2 = false;
                                applicationCall = (ApplicationCall)$this$call$iv.getContext();
                                DropwizardMetrics.access$exception(dropwizardMetrics, applicationCall, e);
                                throw (Throwable)e;
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        {
                            ApplicationCall applicationCall;
                            DropwizardMetrics dropwizardMetrics;
                            PipelineContext pipelineContext;
                            finally {
                                PipelineContext $this$call$iv = pipelineContext;
                                dropwizardMetrics = this.$feature;
                                boolean $i$f$getCall = false;
                                applicationCall = (ApplicationCall)$this$call$iv.getContext();
                                DropwizardMetrics.access$after(dropwizardMetrics, applicationCall);
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$feature = dropwizardMetrics;
                    super(3, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull PipelineContext<Unit, ApplicationCall> $this$create, @NotNull Unit it, @NotNull Continuation<? super Unit> continuation) {
                    Intrinsics.checkParameterIsNotNull($this$create, (String)"$this$create");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                    Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    PipelineContext<Unit, ApplicationCall> pipelineContext = function3.p$ = $this$create;
                    Unit unit = function3.p$0 = it;
                    return function3;
                }

                public final Object invoke(Object object, Object object2, Object object3) {
                    return (this.create((PipelineContext<Unit, ApplicationCall>)((PipelineContext)object), (Unit)object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                }
            });
            pipeline.getEnvironment().getMonitor().subscribe(Routing.Feature.getRoutingCallStarted(), (Function1)new Function1<RoutingApplicationCall, Unit>(feature){
                final /* synthetic */ DropwizardMetrics $feature;

                public final void invoke(@NotNull RoutingApplicationCall call) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    String name = call.getRoute().toString();
                    Meter meter2 = this.$feature.getRegistry().meter(MetricRegistry.name((String)name, (String[])new String[]{"meter"}));
                    Timer timer = this.$feature.getRegistry().timer(MetricRegistry.name((String)name, (String[])new String[]{"timer"}));
                    meter2.mark();
                    Timer.Context context = timer.time();
                    Attributes attributes = call.getAttributes();
                    AttributeKey attributeKey = DropwizardMetrics.access$getRoutingMetricsKey$cp();
                    Timer.Context context2 = context;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context");
                    attributes.put(attributeKey, (Object)new RoutingMetrics(name, context2));
                }
                {
                    this.$feature = dropwizardMetrics;
                    super(1);
                }
            });
            pipeline.getEnvironment().getMonitor().subscribe(Routing.Feature.getRoutingCallFinished(), (Function1)new Function1<RoutingApplicationCall, Unit>(feature){
                final /* synthetic */ DropwizardMetrics $feature;

                public final void invoke(@NotNull RoutingApplicationCall call) {
                    Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                    RoutingMetrics routingMetrics = (RoutingMetrics)call.getAttributes().take(DropwizardMetrics.access$getRoutingMetricsKey$cp());
                    HttpStatusCode httpStatusCode = call.getResponse().status();
                    int status = httpStatusCode != null ? httpStatusCode.getValue() : 0;
                    Meter statusMeter = this.$feature.getRegistry().meter(MetricRegistry.name((String)routingMetrics.getName(), (String[])new String[]{String.valueOf(status)}));
                    statusMeter.mark();
                    routingMetrics.getContext().stop();
                }
                {
                    this.$feature = dropwizardMetrics;
                    super(1);
                }
            });
            return feature;
        }

        private Feature() {
        }

        public /* synthetic */ Feature(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/ktor/metrics/dropwizard/DropwizardMetrics$Feature$RoutingMetrics;", "", "name", "", "context", "Lcom/codahale/metrics/Timer$Context;", "(Ljava/lang/String;Lcom/codahale/metrics/Timer$Context;)V", "getContext", "()Lcom/codahale/metrics/Timer$Context;", "getName", "()Ljava/lang/String;", "ktor-metrics"})
        private static final class RoutingMetrics {
            @NotNull
            private final String name;
            @NotNull
            private final Timer.Context context;

            @NotNull
            public final String getName() {
                return this.name;
            }

            @NotNull
            public final Timer.Context getContext() {
                return this.context;
            }

            public RoutingMetrics(@NotNull String name, @NotNull Timer.Context context) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                this.name = name;
                this.context = context;
            }
        }
    }
}

