/*
 * Kubernetes
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: v1.8.11
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.kubernetes.client.models;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.models.V1alpha1AdmissionHookClientConfig;
import io.kubernetes.client.models.V1alpha1RuleWithOperations;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * ExternalAdmissionHook describes an external admission webhook and the resources and operations it applies to.
 */
@ApiModel(description = "ExternalAdmissionHook describes an external admission webhook and the resources and operations it applies to.")

public class V1alpha1ExternalAdmissionHook {
  @SerializedName("clientConfig")
  private V1alpha1AdmissionHookClientConfig clientConfig = null;

  @SerializedName("failurePolicy")
  private String failurePolicy = null;

  @SerializedName("name")
  private String name = null;

  @SerializedName("rules")
  private List<V1alpha1RuleWithOperations> rules = null;

  public V1alpha1ExternalAdmissionHook clientConfig(V1alpha1AdmissionHookClientConfig clientConfig) {
    this.clientConfig = clientConfig;
    return this;
  }

   /**
   * ClientConfig defines how to communicate with the hook. Required
   * @return clientConfig
  **/
  @ApiModelProperty(required = true, value = "ClientConfig defines how to communicate with the hook. Required")
  public V1alpha1AdmissionHookClientConfig getClientConfig() {
    return clientConfig;
  }

  public void setClientConfig(V1alpha1AdmissionHookClientConfig clientConfig) {
    this.clientConfig = clientConfig;
  }

  public V1alpha1ExternalAdmissionHook failurePolicy(String failurePolicy) {
    this.failurePolicy = failurePolicy;
    return this;
  }

   /**
   * FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.
   * @return failurePolicy
  **/
  @ApiModelProperty(value = "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.")
  public String getFailurePolicy() {
    return failurePolicy;
  }

  public void setFailurePolicy(String failurePolicy) {
    this.failurePolicy = failurePolicy;
  }

  public V1alpha1ExternalAdmissionHook name(String name) {
    this.name = name;
    return this;
  }

   /**
   * The name of the external admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \&quot;imagepolicy\&quot; is the name of the webhook, and kubernetes.io is the name of the organization. Required.
   * @return name
  **/
  @ApiModelProperty(required = true, value = "The name of the external admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public V1alpha1ExternalAdmissionHook rules(List<V1alpha1RuleWithOperations> rules) {
    this.rules = rules;
    return this;
  }

  public V1alpha1ExternalAdmissionHook addRulesItem(V1alpha1RuleWithOperations rulesItem) {
    if (this.rules == null) {
      this.rules = new ArrayList<V1alpha1RuleWithOperations>();
    }
    this.rules.add(rulesItem);
    return this;
  }

   /**
   * Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule.
   * @return rules
  **/
  @ApiModelProperty(value = "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule.")
  public List<V1alpha1RuleWithOperations> getRules() {
    return rules;
  }

  public void setRules(List<V1alpha1RuleWithOperations> rules) {
    this.rules = rules;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1alpha1ExternalAdmissionHook v1alpha1ExternalAdmissionHook = (V1alpha1ExternalAdmissionHook) o;
    return Objects.equals(this.clientConfig, v1alpha1ExternalAdmissionHook.clientConfig) &&
        Objects.equals(this.failurePolicy, v1alpha1ExternalAdmissionHook.failurePolicy) &&
        Objects.equals(this.name, v1alpha1ExternalAdmissionHook.name) &&
        Objects.equals(this.rules, v1alpha1ExternalAdmissionHook.rules);
  }

  @Override
  public int hashCode() {
    return Objects.hash(clientConfig, failurePolicy, name, rules);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1alpha1ExternalAdmissionHook {\n");
    
    sb.append("    clientConfig: ").append(toIndentedString(clientConfig)).append("\n");
    sb.append("    failurePolicy: ").append(toIndentedString(failurePolicy)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    rules: ").append(toIndentedString(rules)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

