/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.ExtensionsV1beta1DeploymentCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DeploymentStatus is the most recently observed status of the Deployment.")
public class ExtensionsV1beta1DeploymentStatus {
    @SerializedName(value="availableReplicas")
    private Integer availableReplicas = null;
    @SerializedName(value="collisionCount")
    private Integer collisionCount = null;
    @SerializedName(value="conditions")
    private List<ExtensionsV1beta1DeploymentCondition> conditions = null;
    @SerializedName(value="observedGeneration")
    private Long observedGeneration = null;
    @SerializedName(value="readyReplicas")
    private Integer readyReplicas = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="unavailableReplicas")
    private Integer unavailableReplicas = null;
    @SerializedName(value="updatedReplicas")
    private Integer updatedReplicas = null;

    public ExtensionsV1beta1DeploymentStatus availableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
        return this;
    }

    @ApiModelProperty(value="Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.")
    public Integer getAvailableReplicas() {
        return this.availableReplicas;
    }

    public void setAvailableReplicas(Integer availableReplicas) {
        this.availableReplicas = availableReplicas;
    }

    public ExtensionsV1beta1DeploymentStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @ApiModelProperty(value="Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public ExtensionsV1beta1DeploymentStatus conditions(List<ExtensionsV1beta1DeploymentCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public ExtensionsV1beta1DeploymentStatus addConditionsItem(ExtensionsV1beta1DeploymentCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ExtensionsV1beta1DeploymentCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="Represents the latest available observations of a deployment's current state.")
    public List<ExtensionsV1beta1DeploymentCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ExtensionsV1beta1DeploymentCondition> conditions) {
        this.conditions = conditions;
    }

    public ExtensionsV1beta1DeploymentStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @ApiModelProperty(value="The generation observed by the deployment controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public ExtensionsV1beta1DeploymentStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @ApiModelProperty(value="Total number of ready pods targeted by this deployment.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public ExtensionsV1beta1DeploymentStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(value="Total number of non-terminated pods targeted by this deployment (their labels match the selector).")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public ExtensionsV1beta1DeploymentStatus unavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
        return this;
    }

    @ApiModelProperty(value="Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.")
    public Integer getUnavailableReplicas() {
        return this.unavailableReplicas;
    }

    public void setUnavailableReplicas(Integer unavailableReplicas) {
        this.unavailableReplicas = unavailableReplicas;
    }

    public ExtensionsV1beta1DeploymentStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @ApiModelProperty(value="Total number of non-terminated pods targeted by this deployment that have the desired template spec.")
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionsV1beta1DeploymentStatus extensionsV1beta1DeploymentStatus = (ExtensionsV1beta1DeploymentStatus)o;
        return Objects.equals(this.availableReplicas, extensionsV1beta1DeploymentStatus.availableReplicas) && Objects.equals(this.collisionCount, extensionsV1beta1DeploymentStatus.collisionCount) && Objects.equals(this.conditions, extensionsV1beta1DeploymentStatus.conditions) && Objects.equals(this.observedGeneration, extensionsV1beta1DeploymentStatus.observedGeneration) && Objects.equals(this.readyReplicas, extensionsV1beta1DeploymentStatus.readyReplicas) && Objects.equals(this.replicas, extensionsV1beta1DeploymentStatus.replicas) && Objects.equals(this.unavailableReplicas, extensionsV1beta1DeploymentStatus.unavailableReplicas) && Objects.equals(this.updatedReplicas, extensionsV1beta1DeploymentStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.availableReplicas, this.collisionCount, this.conditions, this.observedGeneration, this.readyReplicas, this.replicas, this.unavailableReplicas, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtensionsV1beta1DeploymentStatus {\n");
        sb.append("    availableReplicas: ").append(this.toIndentedString(this.availableReplicas)).append("\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    unavailableReplicas: ").append(this.toIndentedString(this.unavailableReplicas)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

