/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.server;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import io.livekit.server.AccessTokenKt;
import io.livekit.server.RoomJoin;
import io.livekit.server.SIPGrant;
import io.livekit.server.VideoGrant;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010,\u001a\u00020-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020+0/\"\u00020+\u00a2\u0006\u0002\u00100J\u0014\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020+01J\u001f\u00102\u001a\u00020-2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020#0/\"\u00020#\u00a2\u0006\u0002\u00103J\u0014\u00102\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020#01J\u0006\u00104\u001a\u00020-J\u0006\u00105\u001a\u00020-J\u0006\u00106\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\r\"\u0004\b\u001d\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lio/livekit/server/AccessToken;", "", "apiKey", "", "secret", "(Ljava/lang/String;Ljava/lang/String;)V", "attributes", "", "getAttributes", "()Ljava/util/Map;", "expiration", "Ljava/util/Date;", "getExpiration", "()Ljava/util/Date;", "setExpiration", "(Ljava/util/Date;)V", "identity", "getIdentity", "()Ljava/lang/String;", "setIdentity", "(Ljava/lang/String;)V", "metadata", "getMetadata", "setMetadata", "name", "getName", "setName", "notBefore", "getNotBefore", "setNotBefore", "sha256", "getSha256", "setSha256", "sipGrants", "", "Lio/livekit/server/SIPGrant;", "ttl", "", "getTtl", "()J", "setTtl", "(J)V", "videoGrants", "Lio/livekit/server/VideoGrant;", "addGrants", "", "grants", "", "([Lio/livekit/server/VideoGrant;)V", "", "addSIPGrants", "([Lio/livekit/server/SIPGrant;)V", "clearGrants", "clearSIPGrants", "toJwt", "server-sdk-kotlin"})
@SourceDebugExtension(value={"SMAP\nAccessToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessToken.kt\nio/livekit/server/AccessToken\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,205:1\n1747#2,3:206\n1179#2,2:209\n1253#2,4:211\n1179#2,2:215\n1253#2,4:217\n1#3:221\n215#4,2:222\n*S KotlinDebug\n*F\n+ 1 AccessToken.kt\nio/livekit/server/AccessToken\n*L\n157#1:206,3\n163#1:209,2\n163#1:211,4\n164#1:215,2\n164#1:217,4\n177#1:222,2\n*E\n"})
public final class AccessToken {
    @NotNull
    private final String apiKey;
    @NotNull
    private final String secret;
    @NotNull
    private final Set<VideoGrant> videoGrants;
    @NotNull
    private final Set<SIPGrant> sipGrants;
    private long ttl;
    @Nullable
    private Date expiration;
    @Nullable
    private Date notBefore;
    @Nullable
    private String name;
    @Nullable
    private String identity;
    @Nullable
    private String metadata;
    @Nullable
    private String sha256;
    @NotNull
    private final Map<String, String> attributes;

    public AccessToken(@NotNull String apiKey, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.apiKey = apiKey;
        this.secret = secret;
        this.videoGrants = new LinkedHashSet();
        this.sipGrants = new LinkedHashSet();
        this.ttl = TimeUnit.MILLISECONDS.convert(6L, TimeUnit.HOURS);
        this.attributes = new LinkedHashMap();
    }

    public final long getTtl() {
        return this.ttl;
    }

    public final void setTtl(long l) {
        this.ttl = l;
    }

    @Nullable
    public final Date getExpiration() {
        return this.expiration;
    }

    public final void setExpiration(@Nullable Date date) {
        this.expiration = date;
    }

    @Nullable
    public final Date getNotBefore() {
        return this.notBefore;
    }

    public final void setNotBefore(@Nullable Date date) {
        this.notBefore = date;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    @Nullable
    public final String getIdentity() {
        return this.identity;
    }

    public final void setIdentity(@Nullable String string) {
        this.identity = string;
    }

    @Nullable
    public final String getMetadata() {
        return this.metadata;
    }

    public final void setMetadata(@Nullable String string) {
        this.metadata = string;
    }

    @Nullable
    public final String getSha256() {
        return this.sha256;
    }

    public final void setSha256(@Nullable String string) {
        this.sha256 = string;
    }

    @NotNull
    public final Map<String, String> getAttributes() {
        return this.attributes;
    }

    public final void addGrants(VideoGrant ... grants) {
        Intrinsics.checkNotNullParameter((Object)grants, (String)"grants");
        for (VideoGrant grant : grants) {
            this.videoGrants.add(grant);
        }
    }

    public final void addGrants(@NotNull Iterable<? extends VideoGrant> grants) {
        Intrinsics.checkNotNullParameter(grants, (String)"grants");
        for (VideoGrant videoGrant : grants) {
            this.videoGrants.add(videoGrant);
        }
    }

    public final void clearGrants() {
        this.videoGrants.clear();
    }

    public final void addSIPGrants(SIPGrant ... grants) {
        Intrinsics.checkNotNullParameter((Object)grants, (String)"grants");
        for (SIPGrant grant : grants) {
            this.sipGrants.add(grant);
        }
    }

    public final void addSIPGrants(@NotNull Iterable<? extends SIPGrant> grants) {
        Intrinsics.checkNotNullParameter(grants, (String)"grants");
        for (SIPGrant sIPGrant : grants) {
            this.sipGrants.add(sIPGrant);
        }
    }

    public final void clearSIPGrants() {
        this.sipGrants.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toJwt() {
        void $this$associateTo$iv$iv;
        Object object;
        void $this$associateTo$iv$iv2;
        Object it;
        String id;
        JWTCreator.Builder $this$toJwt_u24lambda_u248 = JWT.create();
        boolean bl = false;
        $this$toJwt_u24lambda_u248.withIssuer(this.apiKey);
        Date exp = this.expiration;
        if (exp != null) {
            $this$toJwt_u24lambda_u248.withExpiresAt(exp);
        } else {
            $this$toJwt_u24lambda_u248.withExpiresAt(new Date(System.currentTimeMillis() + this.ttl));
        }
        Date nbf = this.notBefore;
        if (nbf != null) {
            $this$toJwt_u24lambda_u248.withNotBefore(nbf);
        }
        if ((id = this.identity) != null) {
            $this$toJwt_u24lambda_u248.withSubject(id);
            $this$toJwt_u24lambda_u248.withJWTId(id);
        } else {
            boolean hasRoomJoin;
            block16: {
                boolean bl2;
                Iterable $this$any$iv = this.videoGrants;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (VideoGrant)element$iv;
                        boolean bl3 = false;
                        if (!(it instanceof RoomJoin && Intrinsics.areEqual((Object)((VideoGrant)it).getValue(), (Object)true))) continue;
                        bl2 = true;
                        break block16;
                    }
                    bl2 = hasRoomJoin = false;
                }
            }
            if (hasRoomJoin) {
                throw new IllegalStateException("identity is required for join, but is not set.");
            }
        }
        Map claimsMap = new LinkedHashMap();
        Iterable $this$associate$iv = this.videoGrants;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        it = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map = destination$iv$iv;
            VideoGrant grant = (VideoGrant)element$iv$iv;
            boolean bl4 = false;
            object = grant.toPair();
            map.put(object.getFirst(), object.getSecond());
        }
        Map videoGrantsMap = destination$iv$iv;
        Iterable $this$associate$iv2 = this.sipGrants;
        boolean $i$f$associate2 = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv2;
            SIPGrant grant = (SIPGrant)element$iv$iv;
            boolean bl5 = false;
            Pair<String, Object> pair = grant.toPair();
            object.put((Object)pair.getFirst(), (Object)pair.getSecond());
        }
        Map sipGrantsMap = destination$iv$iv2;
        String string = this.name;
        if (string != null) {
            String it2 = string;
            boolean bl6 = false;
            claimsMap.put("name", it2);
        }
        String string2 = this.metadata;
        if (string2 != null) {
            String it3 = string2;
            boolean bl7 = false;
            claimsMap.put("metadata", it3);
        }
        String string3 = this.sha256;
        if (string3 != null) {
            String it4 = string3;
            boolean bl8 = false;
            claimsMap.put("sha256", it4);
        }
        Map attributesCopy = MapsKt.toMap(this.attributes);
        boolean bl9 = false;
        if (!attributesCopy.isEmpty()) {
            claimsMap.put("attributes", attributesCopy);
        }
        claimsMap.put("video", videoGrantsMap);
        claimsMap.put("sip", sipGrantsMap);
        Map $this$forEach$iv = claimsMap;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl10 = false;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Intrinsics.checkNotNull((Object)$this$toJwt_u24lambda_u248);
            AccessTokenKt.withClaimAny($this$toJwt_u24lambda_u248, key, value);
        }
        Algorithm alg = Algorithm.HMAC256((String)this.secret);
        String string4 = $this$toJwt_u24lambda_u248.sign(alg);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"with(...)");
        return string4;
    }
}

