/*
 * Decompiled with CFR 0.152.
 */
package io.livekit.server;

import com.google.protobuf.ByteString;
import io.livekit.server.AccessToken;
import io.livekit.server.RoomAdmin;
import io.livekit.server.RoomCreate;
import io.livekit.server.RoomList;
import io.livekit.server.RoomName;
import io.livekit.server.RoomService;
import io.livekit.server.RoomServiceClient;
import io.livekit.server.VideoGrant;
import io.livekit.server.okhttp.OkHttpFactory;
import io.livekit.server.retrofit.TransformCall;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import livekit.LivekitModels;
import livekit.LivekitRoom;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.protobuf.ProtoConverterFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 <2\u00020\u0001:\u0001<B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J!\u0010\b\u001a\u00020\u00052\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ{\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0012H\u0007\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000e2\u0006\u0010\u001e\u001a\u00020\u0005J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J\u001a\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0#0\u000e2\u0006\u0010\u001e\u001a\u00020\u0005J&\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0#0\u000e2\u0010\b\u0002\u0010%\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010#H\u0007J,\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0019J\u001e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005JT\u0010+\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u000e\b\u0002\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050#2\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050#2\n\b\u0002\u00102\u001a\u0004\u0018\u00010\u0005H\u0007JZ\u00103\u001a\b\u0012\u0004\u0012\u00020 0\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u00104\u001a\u0004\u0018\u0001052\u0016\b\u0002\u00106\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u000107H\u0007J\u001c\u00108\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J4\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u000e2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050#2\u0006\u0010;\u001a\u00020\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lio/livekit/server/RoomServiceClient;", "", "service", "Lio/livekit/server/RoomService;", "apiKey", "", "secret", "(Lio/livekit/server/RoomService;Ljava/lang/String;Ljava/lang/String;)V", "authHeader", "videoGrants", "", "Lio/livekit/server/VideoGrant;", "([Lio/livekit/server/VideoGrant;)Ljava/lang/String;", "createRoom", "Lretrofit2/Call;", "Llivekit/LivekitModels$Room;", "name", "emptyTimeout", "", "maxParticipants", "nodeId", "metadata", "minPlayoutDelay", "maxPlayoutDelay", "syncStreams", "", "departureTimeout", "(Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Integer;)Lretrofit2/Call;", "deleteRoom", "Ljava/lang/Void;", "roomName", "getParticipant", "Llivekit/LivekitModels$ParticipantInfo;", "identity", "listParticipants", "", "listRooms", "names", "mutePublishedTrack", "Llivekit/LivekitModels$TrackInfo;", "trackSid", "mute", "removeParticipant", "sendData", "data", "", "kind", "Llivekit/LivekitModels$DataPacket$Kind;", "destinationSids", "destinationIdentities", "topic", "updateParticipant", "participantPermission", "Llivekit/LivekitModels$ParticipantPermission;", "attributes", "", "updateRoomMetadata", "updateSubscriptions", "trackSids", "subscribe", "Companion", "server-sdk-kotlin"})
public final class RoomServiceClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RoomService service;
    @NotNull
    private final String apiKey;
    @NotNull
    private final String secret;

    public RoomServiceClient(@NotNull RoomService service, @NotNull String apiKey, @NotNull String secret) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.service = service;
        this.apiKey = apiKey;
        this.secret = secret;
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout, @Nullable Integer maxParticipants, @Nullable String nodeId, @Nullable String metadata, @Nullable Integer minPlayoutDelay, @Nullable Integer maxPlayoutDelay, @Nullable Boolean syncStreams, @Nullable Integer departureTimeout) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LivekitRoom.CreateRoomRequest.Builder $this$createRoom_u24lambda_u240 = LivekitRoom.CreateRoomRequest.newBuilder();
        boolean bl = false;
        $this$createRoom_u24lambda_u240.setName(name);
        if (emptyTimeout != null) {
            $this$createRoom_u24lambda_u240.setEmptyTimeout(emptyTimeout);
        }
        if (maxParticipants != null) {
            $this$createRoom_u24lambda_u240.setMaxParticipants(maxParticipants);
        }
        if (nodeId != null) {
            $this$createRoom_u24lambda_u240.setNodeId(nodeId);
        }
        if (metadata != null) {
            $this$createRoom_u24lambda_u240.setMetadata(metadata);
        }
        if (minPlayoutDelay != null) {
            $this$createRoom_u24lambda_u240.setMinPlayoutDelay(minPlayoutDelay);
        }
        if (maxPlayoutDelay != null) {
            $this$createRoom_u24lambda_u240.setMaxPlayoutDelay(maxPlayoutDelay);
        }
        if (syncStreams != null) {
            $this$createRoom_u24lambda_u240.setSyncStreams(syncStreams);
        }
        if (departureTimeout != null) {
            $this$createRoom_u24lambda_u240.setDepartureTimeout(departureTimeout);
        }
        LivekitRoom.CreateRoomRequest request = $this$createRoom_u24lambda_u240.build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomCreate(true)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.createRoom(request, credentials);
    }

    public static /* synthetic */ Call createRoom$default(RoomServiceClient roomServiceClient, String string, Integer n, Integer n2, String string2, String string3, Integer n3, Integer n4, Boolean bl, Integer n5, int n6, Object object) {
        if ((n6 & 2) != 0) {
            n = null;
        }
        if ((n6 & 4) != 0) {
            n2 = null;
        }
        if ((n6 & 8) != 0) {
            string2 = null;
        }
        if ((n6 & 0x10) != 0) {
            string3 = null;
        }
        if ((n6 & 0x20) != 0) {
            n3 = null;
        }
        if ((n6 & 0x40) != 0) {
            n4 = null;
        }
        if ((n6 & 0x80) != 0) {
            bl = null;
        }
        if ((n6 & 0x100) != 0) {
            n5 = null;
        }
        return roomServiceClient.createRoom(string, n, n2, string2, string3, n3, n4, bl, n5);
    }

    @JvmOverloads
    @NotNull
    public final Call<List<LivekitModels.Room>> listRooms(@Nullable List<String> names) {
        LivekitRoom.ListRoomsRequest.Builder $this$listRooms_u24lambda_u241 = LivekitRoom.ListRoomsRequest.newBuilder();
        boolean bl = false;
        if (names != null) {
            $this$listRooms_u24lambda_u241.addAllNames((Iterable<String>)names);
        }
        LivekitRoom.ListRoomsRequest request = $this$listRooms_u24lambda_u241.build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomList(true)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return new TransformCall(this.service.listRooms(request, credentials), listRooms.1.INSTANCE);
    }

    public static /* synthetic */ Call listRooms$default(RoomServiceClient roomServiceClient, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        return roomServiceClient.listRooms(list);
    }

    @NotNull
    public final Call<Void> deleteRoom(@NotNull String roomName) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        LivekitRoom.DeleteRoomRequest request = LivekitRoom.DeleteRoomRequest.newBuilder().setRoom(roomName).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomCreate(true)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.deleteRoom(request, credentials);
    }

    @NotNull
    public final Call<LivekitModels.Room> updateRoomMetadata(@NotNull String roomName, @NotNull String metadata) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        LivekitRoom.UpdateRoomMetadataRequest request = LivekitRoom.UpdateRoomMetadataRequest.newBuilder().setRoom(roomName).setMetadata(metadata).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.updateRoomMetadata(request, credentials);
    }

    @NotNull
    public final Call<List<LivekitModels.ParticipantInfo>> listParticipants(@NotNull String roomName) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        LivekitRoom.ListParticipantsRequest request = LivekitRoom.ListParticipantsRequest.newBuilder().setRoom(roomName).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return new TransformCall(this.service.listParticipants(request, credentials), listParticipants.1.INSTANCE);
    }

    @NotNull
    public final Call<LivekitModels.ParticipantInfo> getParticipant(@NotNull String roomName, @NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        LivekitRoom.RoomParticipantIdentity request = LivekitRoom.RoomParticipantIdentity.newBuilder().setRoom(roomName).setIdentity(identity).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.getParticipant(request, credentials);
    }

    @NotNull
    public final Call<Void> removeParticipant(@NotNull String roomName, @NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        LivekitRoom.RoomParticipantIdentity request = LivekitRoom.RoomParticipantIdentity.newBuilder().setRoom(roomName).setIdentity(identity).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.removeParticipant(request, credentials);
    }

    @NotNull
    public final Call<LivekitModels.TrackInfo> mutePublishedTrack(@NotNull String roomName, @NotNull String identity, @NotNull String trackSid, boolean mute) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter((Object)trackSid, (String)"trackSid");
        LivekitRoom.MuteRoomTrackRequest request = LivekitRoom.MuteRoomTrackRequest.newBuilder().setRoom(roomName).setIdentity(identity).setTrackSid(trackSid).setMuted(mute).build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return new TransformCall(this.service.mutePublishedTrack(request, credentials), mutePublishedTrack.1.INSTANCE);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.ParticipantInfo> updateParticipant(@NotNull String roomName, @NotNull String identity, @Nullable String name, @Nullable String metadata, @Nullable LivekitModels.ParticipantPermission participantPermission, @Nullable Map<String, String> attributes) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        LivekitRoom.UpdateParticipantRequest.Builder $this$updateParticipant_u24lambda_u242 = LivekitRoom.UpdateParticipantRequest.newBuilder();
        boolean bl = false;
        $this$updateParticipant_u24lambda_u242.setRoom(roomName);
        $this$updateParticipant_u24lambda_u242.setIdentity(identity);
        if (name != null) {
            $this$updateParticipant_u24lambda_u242.setName(name);
        }
        if (metadata != null) {
            $this$updateParticipant_u24lambda_u242.setMetadata(metadata);
        }
        if (participantPermission != null) {
            $this$updateParticipant_u24lambda_u242.setPermission(participantPermission);
        }
        if (attributes != null) {
            $this$updateParticipant_u24lambda_u242.putAllAttributes(attributes);
        }
        LivekitRoom.UpdateParticipantRequest request = $this$updateParticipant_u24lambda_u242.build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.updateParticipant(request, credentials);
    }

    public static /* synthetic */ Call updateParticipant$default(RoomServiceClient roomServiceClient, String string, String string2, String string3, String string4, LivekitModels.ParticipantPermission participantPermission, Map map, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        if ((n & 8) != 0) {
            string4 = null;
        }
        if ((n & 0x10) != 0) {
            participantPermission = null;
        }
        if ((n & 0x20) != 0) {
            map = null;
        }
        return roomServiceClient.updateParticipant(string, string2, string3, string4, participantPermission, map);
    }

    @NotNull
    public final Call<Void> updateSubscriptions(@NotNull String roomName, @NotNull String identity, @NotNull List<String> trackSids, boolean subscribe) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        Intrinsics.checkNotNullParameter(trackSids, (String)"trackSids");
        LivekitRoom.UpdateSubscriptionsRequest.Builder $this$updateSubscriptions_u24lambda_u243 = LivekitRoom.UpdateSubscriptionsRequest.newBuilder();
        boolean bl = false;
        $this$updateSubscriptions_u24lambda_u243.setRoom(roomName);
        $this$updateSubscriptions_u24lambda_u243.setIdentity(identity);
        $this$updateSubscriptions_u24lambda_u243.addAllTrackSids((Iterable<String>)trackSids);
        $this$updateSubscriptions_u24lambda_u243.setSubscribe(subscribe);
        LivekitRoom.UpdateSubscriptionsRequest request = $this$updateSubscriptions_u24lambda_u243.build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.updateSubscriptions(request, credentials);
    }

    @JvmOverloads
    @NotNull
    public final Call<Void> sendData(@NotNull String roomName, @NotNull byte[] data, @NotNull LivekitModels.DataPacket.Kind kind, @NotNull List<String> destinationSids, @NotNull List<String> destinationIdentities, @Nullable String topic) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(destinationSids, (String)"destinationSids");
        Intrinsics.checkNotNullParameter(destinationIdentities, (String)"destinationIdentities");
        UUID uuid = UUID.randomUUID();
        ByteBuffer b = ByteBuffer.wrap(new byte[16]);
        b.putLong(uuid.getMostSignificantBits());
        b.putLong(uuid.getLeastSignificantBits());
        LivekitRoom.SendDataRequest.Builder $this$sendData_u24lambda_u244 = LivekitRoom.SendDataRequest.newBuilder();
        boolean bl = false;
        $this$sendData_u24lambda_u244.setRoom(roomName);
        $this$sendData_u24lambda_u244.setData(ByteString.copyFrom((byte[])data));
        $this$sendData_u24lambda_u244.setKind(kind);
        $this$sendData_u24lambda_u244.addAllDestinationSids((Iterable<String>)destinationSids);
        $this$sendData_u24lambda_u244.addAllDestinationIdentities((Iterable<String>)destinationIdentities);
        if (topic != null) {
            $this$sendData_u24lambda_u244.setTopic(topic);
        }
        $this$sendData_u24lambda_u244.setNonce(ByteString.copyFrom((ByteBuffer)b));
        LivekitRoom.SendDataRequest request = $this$sendData_u24lambda_u244.build();
        VideoGrant[] videoGrantArray = new VideoGrant[]{new RoomAdmin(true), new RoomName(roomName)};
        String credentials = this.authHeader(videoGrantArray);
        Intrinsics.checkNotNull((Object)request);
        return this.service.sendData(request, credentials);
    }

    public static /* synthetic */ Call sendData$default(RoomServiceClient roomServiceClient, String string, byte[] byArray, LivekitModels.DataPacket.Kind kind, List list, List list2, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        return roomServiceClient.sendData(string, byArray, kind, list, list2, string2);
    }

    private final String authHeader(VideoGrant ... videoGrants) {
        AccessToken accessToken = new AccessToken(this.apiKey, this.secret);
        accessToken.addGrants(Arrays.copyOf(videoGrants, videoGrants.length));
        String jwt = accessToken.toJwt();
        return "Bearer " + jwt;
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout, @Nullable Integer maxParticipants, @Nullable String nodeId, @Nullable String metadata, @Nullable Integer minPlayoutDelay, @Nullable Integer maxPlayoutDelay, @Nullable Boolean syncStreams) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, emptyTimeout, maxParticipants, nodeId, metadata, minPlayoutDelay, maxPlayoutDelay, syncStreams, null, 256, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout, @Nullable Integer maxParticipants, @Nullable String nodeId, @Nullable String metadata, @Nullable Integer minPlayoutDelay, @Nullable Integer maxPlayoutDelay) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, emptyTimeout, maxParticipants, nodeId, metadata, minPlayoutDelay, maxPlayoutDelay, null, null, 384, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout, @Nullable Integer maxParticipants, @Nullable String nodeId, @Nullable String metadata, @Nullable Integer minPlayoutDelay) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, emptyTimeout, maxParticipants, nodeId, metadata, minPlayoutDelay, null, null, null, 448, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout, @Nullable Integer maxParticipants, @Nullable String nodeId, @Nullable String metadata) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, emptyTimeout, maxParticipants, nodeId, metadata, null, null, null, null, 480, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout, @Nullable Integer maxParticipants, @Nullable String nodeId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, emptyTimeout, maxParticipants, nodeId, null, null, null, null, null, 496, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout, @Nullable Integer maxParticipants) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, emptyTimeout, maxParticipants, null, null, null, null, null, null, 504, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name, @Nullable Integer emptyTimeout) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, emptyTimeout, null, null, null, null, null, null, null, 508, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.Room> createRoom(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return RoomServiceClient.createRoom$default(this, name, null, null, null, null, null, null, null, null, 510, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<List<LivekitModels.Room>> listRooms() {
        return RoomServiceClient.listRooms$default(this, null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.ParticipantInfo> updateParticipant(@NotNull String roomName, @NotNull String identity, @Nullable String name, @Nullable String metadata, @Nullable LivekitModels.ParticipantPermission participantPermission) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return RoomServiceClient.updateParticipant$default(this, roomName, identity, name, metadata, participantPermission, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.ParticipantInfo> updateParticipant(@NotNull String roomName, @NotNull String identity, @Nullable String name, @Nullable String metadata) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return RoomServiceClient.updateParticipant$default(this, roomName, identity, name, metadata, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.ParticipantInfo> updateParticipant(@NotNull String roomName, @NotNull String identity, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return RoomServiceClient.updateParticipant$default(this, roomName, identity, name, null, null, null, 56, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<LivekitModels.ParticipantInfo> updateParticipant(@NotNull String roomName, @NotNull String identity) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        return RoomServiceClient.updateParticipant$default(this, roomName, identity, null, null, null, null, 60, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<Void> sendData(@NotNull String roomName, @NotNull byte[] data, @NotNull LivekitModels.DataPacket.Kind kind, @NotNull List<String> destinationSids, @NotNull List<String> destinationIdentities) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(destinationSids, (String)"destinationSids");
        Intrinsics.checkNotNullParameter(destinationIdentities, (String)"destinationIdentities");
        return RoomServiceClient.sendData$default(this, roomName, data, kind, destinationSids, destinationIdentities, null, 32, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<Void> sendData(@NotNull String roomName, @NotNull byte[] data, @NotNull LivekitModels.DataPacket.Kind kind, @NotNull List<String> destinationSids) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(destinationSids, (String)"destinationSids");
        return RoomServiceClient.sendData$default(this, roomName, data, kind, destinationSids, null, null, 48, null);
    }

    @JvmOverloads
    @NotNull
    public final Call<Void> sendData(@NotNull String roomName, @NotNull byte[] data, @NotNull LivekitModels.DataPacket.Kind kind) {
        Intrinsics.checkNotNullParameter((Object)roomName, (String)"roomName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        return RoomServiceClient.sendData$default(this, roomName, data, kind, null, null, null, 56, null);
    }

    @Deprecated(message="Use RoomServiceClient.createClient()", replaceWith=@ReplaceWith(expression="RoomServiceClient.createClient(host, apiKey, secret, OkHttpFactory(logging, okHttpConfigurator))", imports={"import io.livekit.server.okhttp.OkHttpFactory"}))
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RoomServiceClient create(@NotNull String host, @NotNull String apiKey, @NotNull String secret, boolean logging, @Nullable Consumer<OkHttpClient.Builder> okHttpConfigurator) {
        return Companion.create(host, apiKey, secret, logging, okHttpConfigurator);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RoomServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret, @NotNull Supplier<OkHttpClient> okHttpSupplier) {
        return Companion.createClient(host, apiKey, secret, okHttpSupplier);
    }

    @Deprecated(message="Use RoomServiceClient.createClient()", replaceWith=@ReplaceWith(expression="RoomServiceClient.createClient(host, apiKey, secret, OkHttpFactory(logging, okHttpConfigurator))", imports={"import io.livekit.server.okhttp.OkHttpFactory"}))
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RoomServiceClient create(@NotNull String host, @NotNull String apiKey, @NotNull String secret, boolean logging) {
        return Companion.create(host, apiKey, secret, logging);
    }

    @Deprecated(message="Use RoomServiceClient.createClient()", replaceWith=@ReplaceWith(expression="RoomServiceClient.createClient(host, apiKey, secret, OkHttpFactory(logging, okHttpConfigurator))", imports={"import io.livekit.server.okhttp.OkHttpFactory"}))
    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RoomServiceClient create(@NotNull String host, @NotNull String apiKey, @NotNull String secret) {
        return Companion.create(host, apiKey, secret);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final RoomServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret) {
        return Companion.createClient(host, apiKey, secret);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\u0010\b\u0002\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0007J0\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007\u00a8\u0006\u0012"}, d2={"Lio/livekit/server/RoomServiceClient$Companion;", "", "()V", "create", "Lio/livekit/server/RoomServiceClient;", "host", "", "apiKey", "secret", "logging", "", "okHttpConfigurator", "Ljava/util/function/Consumer;", "Lokhttp3/OkHttpClient$Builder;", "createClient", "okHttpSupplier", "Ljava/util/function/Supplier;", "Lokhttp3/OkHttpClient;", "server-sdk-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Use RoomServiceClient.createClient()", replaceWith=@ReplaceWith(expression="RoomServiceClient.createClient(host, apiKey, secret, OkHttpFactory(logging, okHttpConfigurator))", imports={"import io.livekit.server.okhttp.OkHttpFactory"}))
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RoomServiceClient create(@NotNull String host, @NotNull String apiKey, @NotNull String secret, boolean logging, @Nullable Consumer<OkHttpClient.Builder> okHttpConfigurator) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return this.createClient(host, apiKey, secret, new OkHttpFactory(logging, okHttpConfigurator));
        }

        public static /* synthetic */ RoomServiceClient create$default(Companion companion, String string, String string2, String string3, boolean bl, Consumer consumer, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                consumer = null;
            }
            return companion.create(string, string2, string3, bl, consumer);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RoomServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret, @NotNull Supplier<OkHttpClient> okHttpSupplier) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            Intrinsics.checkNotNullParameter(okHttpSupplier, (String)"okHttpSupplier");
            OkHttpClient okHttpClient = okHttpSupplier.get();
            Intrinsics.checkNotNullExpressionValue((Object)okHttpClient, (String)"get(...)");
            OkHttpClient okhttp = okHttpClient;
            RoomService service = (RoomService)new Retrofit.Builder().baseUrl(host).addConverterFactory((Converter.Factory)ProtoConverterFactory.create()).client(okhttp).build().create(RoomService.class);
            Intrinsics.checkNotNull((Object)service);
            return new RoomServiceClient(service, apiKey, secret);
        }

        public static /* synthetic */ RoomServiceClient createClient$default(Companion companion, String string, String string2, String string3, Supplier supplier, int n, Object object) {
            if ((n & 8) != 0) {
                supplier = new OkHttpFactory(false, null, 3, null);
            }
            return companion.createClient(string, string2, string3, supplier);
        }

        @Deprecated(message="Use RoomServiceClient.createClient()", replaceWith=@ReplaceWith(expression="RoomServiceClient.createClient(host, apiKey, secret, OkHttpFactory(logging, okHttpConfigurator))", imports={"import io.livekit.server.okhttp.OkHttpFactory"}))
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RoomServiceClient create(@NotNull String host, @NotNull String apiKey, @NotNull String secret, boolean logging) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return io.livekit.server.RoomServiceClient$Companion.create$default(this, host, apiKey, secret, logging, null, 16, null);
        }

        @Deprecated(message="Use RoomServiceClient.createClient()", replaceWith=@ReplaceWith(expression="RoomServiceClient.createClient(host, apiKey, secret, OkHttpFactory(logging, okHttpConfigurator))", imports={"import io.livekit.server.okhttp.OkHttpFactory"}))
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RoomServiceClient create(@NotNull String host, @NotNull String apiKey, @NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return io.livekit.server.RoomServiceClient$Companion.create$default(this, host, apiKey, secret, false, null, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final RoomServiceClient createClient(@NotNull String host, @NotNull String apiKey, @NotNull String secret) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            return io.livekit.server.RoomServiceClient$Companion.createClient$default(this, host, apiKey, secret, null, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

