/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.ganglia;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.ganglia.GangliaConfig;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GangliaMeterRegistry
extends DropwizardMeterRegistry {
    private final GangliaReporter reporter;
    private final GangliaConfig config;

    public GangliaMeterRegistry(GangliaConfig config, Clock clock) {
        this(config, clock, HierarchicalNameMapper.DEFAULT);
    }

    public GangliaMeterRegistry(GangliaConfig config, Clock clock, HierarchicalNameMapper nameMapper) {
        this(config, clock, nameMapper, new MetricRegistry());
    }

    public GangliaMeterRegistry(GangliaConfig config, Clock clock, HierarchicalNameMapper nameMapper, MetricRegistry metricRegistry) {
        super((DropwizardConfig)config, metricRegistry, nameMapper, clock);
        this.config = config;
        try {
            GMetric ganglia = new GMetric(config.host(), config.port(), config.addressingMode(), config.ttl());
            this.reporter = GangliaReporter.forRegistry((MetricRegistry)this.getDropwizardRegistry()).convertRatesTo(config.rateUnits()).convertDurationsTo(config.durationUnits()).build(ganglia);
            if (config.enabled()) {
                this.start();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to configure Ganglia metrics reporting", e);
        }
    }

    public void stop() {
        this.reporter.stop();
    }

    public void start() {
        this.reporter.start(this.config.step().getSeconds(), TimeUnit.SECONDS);
    }

    public void close() {
        this.stop();
        super.close();
    }

    protected Double nullGaugeValue() {
        return Double.NaN;
    }
}

