/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public class AnnotationUtil {
    public static final String KOTLIN_METADATA = "kotlin.Metadata";
    public static final List<String> INTERNAL_ANNOTATION_NAMES = Arrays.asList(Retention.class.getName(), "kotlin.annotation.Retention", Inherited.class.getName(), SuppressWarnings.class.getName(), Override.class.getName(), Repeatable.class.getName(), Documented.class.getName(), "kotlin.annotation.MustBeDocumented", Target.class.getName(), "kotlin.annotation.Target", "kotlin.Metadata");
    public static final Annotation[] ZERO_ANNOTATIONS = new Annotation[0];
    public static final AnnotatedElement[] ZERO_ANNOTATED_ELEMENTS = new AnnotatedElement[0];
    public static final AnnotatedElement EMPTY_ANNOTATED_ELEMENT = new AnnotatedElement(){

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return ZERO_ANNOTATIONS;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return ZERO_ANNOTATIONS;
        }
    };
    private static final Map<Integer, List<String>> INTERN_LIST_POOL = new ConcurrentHashMap<Integer, List<String>>();
    private static final Map<String, Map<String, Object>> INTERN_MAP_POOL = new ConcurrentHashMap<String, Map<String, Object>>();

    public static List<String> internListOf(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        Integer hash = Arrays.hashCode(objects);
        return INTERN_LIST_POOL.computeIfAbsent(hash, integer -> StringUtils.internListOf(objects));
    }

    public static Map<String, Object> internMapOf(Object ... values) {
        if (values == null || values.length == 0) {
            return Collections.emptyMap();
        }
        int len = values.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Number of arguments should be an even number representing the keys and values");
        }
        if (len == 2) {
            Object value = values[1];
            if (value == Collections.EMPTY_MAP) {
                String key = values[0].toString().intern();
                return INTERN_MAP_POOL.computeIfAbsent(key, s -> Collections.singletonMap(s, Collections.emptyMap()));
            }
            return StringUtils.internMapOf(values);
        }
        return StringUtils.internMapOf(values);
    }

    public static int calculateHashCode(Map<? extends CharSequence, Object> values) {
        int hashCode = 0;
        for (Map.Entry<? extends CharSequence, Object> member : values.entrySet()) {
            Object value = member.getValue();
            int nameHashCode = member.getKey().hashCode();
            int valueHashCode = !value.getClass().isArray() ? value.hashCode() : (value.getClass() == boolean[].class ? Arrays.hashCode((boolean[])value) : (value.getClass() == byte[].class ? Arrays.hashCode((byte[])value) : (value.getClass() == char[].class ? Arrays.hashCode((char[])value) : (value.getClass() == double[].class ? Arrays.hashCode((double[])value) : (value.getClass() == float[].class ? Arrays.hashCode((float[])value) : (value.getClass() == int[].class ? Arrays.hashCode((int[])value) : (value.getClass() == long[].class ? Arrays.hashCode((long[])value) : (value.getClass() == short[].class ? Arrays.hashCode((short[])value) : Arrays.hashCode((Object[])value)))))))));
            hashCode += 127 * nameHashCode ^ valueHashCode;
        }
        return hashCode;
    }

    public static boolean areEqual(Object o1, Object o2) {
        return !o1.getClass().isArray() ? o1.equals(o2) : (o1.getClass() == boolean[].class ? Arrays.equals((boolean[])o1, (boolean[])o2) : (o1.getClass() == byte[].class ? Arrays.equals((byte[])o1, (byte[])o2) : (o1.getClass() == char[].class ? Arrays.equals((char[])o1, (char[])o2) : (o1.getClass() == double[].class ? Arrays.equals((double[])o1, (double[])o2) : (o1.getClass() == float[].class ? Arrays.equals((float[])o1, (float[])o2) : (o1.getClass() == int[].class ? Arrays.equals((int[])o1, (int[])o2) : (o1.getClass() == long[].class ? Arrays.equals((long[])o1, (long[])o2) : (o1.getClass() == short[].class ? Arrays.equals((short[])o1, (short[])o2) : Arrays.equals((Object[])o1, (Object[])o2)))))))));
    }
}

