/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanProperty;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public abstract class AbstractBeanProperty<B, P>
implements BeanProperty<B, P> {
    private final BeanIntrospection<B> introspection;
    private final Class<B> beanType;
    private final Class<P> type;
    private final String name;
    private final AnnotationMetadata annotationMetadata;
    private final Argument[] typeArguments;

    @Internal
    protected AbstractBeanProperty(@Nonnull BeanIntrospection<B> introspection, @Nonnull Class<P> type, @Nonnull String name, @Nullable AnnotationMetadata annotationMetadata, @Nullable Argument[] typeArguments) {
        this.introspection = introspection;
        this.type = type;
        this.beanType = introspection.getBeanType();
        this.name = name.intern();
        this.annotationMetadata = annotationMetadata == null ? AnnotationMetadata.EMPTY_METADATA : annotationMetadata;
        this.typeArguments = typeArguments;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public Class<P> getType() {
        return this.type;
    }

    @Override
    public Argument<P> asArgument() {
        if (this.typeArguments != null) {
            return Argument.of(this.type, this.name, this.typeArguments);
        }
        return Argument.of(this.type, this.name);
    }

    @Override
    @Nonnull
    public BeanIntrospection<B> getDeclaringBean() {
        return this.introspection;
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    @Nullable
    public final P get(@Nonnull B bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (!this.beanType.isInstance(bean)) {
            throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + this.introspection.getBeanType());
        }
        if (this.isWriteOnly()) {
            throw new UnsupportedOperationException("Cannot read from a write-only property");
        }
        return this.readInternal(bean);
    }

    @Override
    public final void set(@Nonnull B bean, @Nullable P value) {
        ArgumentUtils.requireNonNull("bean", bean);
        if (!this.beanType.isInstance(bean)) {
            throw new IllegalArgumentException("Invalid bean [" + bean + "] for type: " + this.introspection.getBeanType());
        }
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("Cannot write a read-only property");
        }
        if (value != null && !ReflectionUtils.getWrapperType(this.getType()).isInstance(value)) {
            throw new IllegalArgumentException("Specified value [" + value + "] is not of the correct type: " + this.getType());
        }
        this.writeInternal(bean, value);
    }

    @Internal
    protected abstract void writeInternal(@Nonnull B var1, @Nullable P var2);

    @Internal
    protected abstract P readInternal(@Nonnull B var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBeanProperty that = (AbstractBeanProperty)o;
        return Objects.equals(this.beanType, that.beanType) && Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.beanType, this.type, this.name);
    }

    public String toString() {
        return "BeanProperty{beanType=" + this.beanType + ", type=" + this.type + ", name='" + this.name + '\'' + '}';
    }
}

