/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import java.util.Objects;
import javax.annotation.Nonnull;

public class ArgumentUtils {
    @Nonnull
    public static Number requirePositive(String name, Number value) {
        ArgumentUtils.requireNonNull(name, value);
        ArgumentUtils.requirePositive(name, value.intValue());
        return value;
    }

    public static <T> T requireNonNull(String name, T value) {
        Objects.requireNonNull(value, "Argument [" + name + "] cannot be null");
        return value;
    }

    public static int requirePositive(String name, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Argument [" + name + "] cannot be negative");
        }
        return value;
    }

    public static ArgumentCheck check(Check check) {
        return new ArgumentCheck(check);
    }

    public static <T> ArgumentCheck check(String name, T value) {
        return new ArgumentCheck<T>(name, value);
    }

    @FunctionalInterface
    public static interface Check {
        public boolean condition();
    }

    public static class ArgumentCheck<T> {
        private final Check check;
        private final String name;
        private final T value;

        public ArgumentCheck(Check check) {
            this.check = check;
            this.name = null;
            this.value = null;
        }

        public ArgumentCheck(String name, T value) {
            this.check = null;
            this.name = name;
            this.value = value;
        }

        public void orElseFail(String message) {
            if (this.check != null && !this.check.condition()) {
                throw new IllegalArgumentException(message);
            }
        }

        public void notNull() {
            if (this.name != null && this.value != null) {
                Objects.requireNonNull(this.value, "Argument [" + this.name + "] cannot be null");
            }
        }
    }
}

