/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class StringUtils {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String EMPTY_STRING = "";
    public static final char SPACE = ' ';
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");

    public static boolean isEmpty(@Nullable CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(@Nullable CharSequence str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean hasText(@Nullable CharSequence str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static List<String> internListOf(Object ... objects) {
        if (objects == null || objects.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> strings = new ArrayList<String>(objects.length);
        for (Object object : objects) {
            strings.add(object.toString().intern());
        }
        return Collections.unmodifiableList(strings);
    }

    public static Map<String, Object> internMapOf(Object ... values) {
        if (values == null) {
            return Collections.emptyMap();
        }
        int len = values.length;
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Number of arguments should be an even number representing the keys and values");
        }
        HashMap<String, Object> answer = new HashMap<String, Object>((int)((double)(len / 2) / 0.75));
        int i = 0;
        while (i < values.length - 1) {
            String key = values[i++].toString().intern();
            Object val = values[i++];
            answer.put(key, val);
        }
        return answer;
    }

    public static boolean isDigits(String str) {
        return StringUtils.isNotEmpty(str) && DIGIT_PATTERN.matcher(str).matches();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtils.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens.toArray(new String[0]);
    }

    public static String convertDotToUnderscore(String dottedProperty) {
        return StringUtils.convertDotToUnderscore(dottedProperty, true);
    }

    public static String convertDotToUnderscore(String dottedProperty, boolean uppercase) {
        if (dottedProperty == null) {
            return dottedProperty;
        }
        Optional<String> converted = Optional.of(dottedProperty).map(value -> value.replace('.', '_')).map(value -> uppercase ? value.toUpperCase() : value);
        return converted.get();
    }

    public static String prependUri(String baseUri, String uri) {
        if (!uri.startsWith("/")) {
            uri = "/" + uri;
        }
        if (uri.length() == 1 && uri.charAt(0) == '/') {
            uri = EMPTY_STRING;
        }
        uri = baseUri + uri;
        return uri.replaceAll("[\\/]{2,}", "/");
    }

    public static String capitalize(String str) {
        char[] array = str.toCharArray();
        if (array.length > 0) {
            array[0] = Character.toUpperCase(array[0]);
        }
        return new String(array);
    }

    @Nullable
    public static String trimToNull(@Nullable String string) {
        return Optional.ofNullable(string).map(String::trim).filter(StringUtils::isNotEmpty).orElse(null);
    }
}

