/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty.converters;

import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.TypeConverter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import java.util.Optional;
import javax.inject.Singleton;

@Factory
@Internal
public class ByteBufConverters {
    @Singleton
    @Bean
    TypeConverter<ByteBuf, CharSequence> byteBufCharSequenceTypeConverter() {
        return (object, targetType, context) -> Optional.of(object.toString(context.getCharset()));
    }

    @Singleton
    @Bean
    TypeConverter<CompositeByteBuf, CharSequence> compositeByteBufCharSequenceTypeConverter() {
        return (object, targetType, context) -> Optional.of(object.toString(context.getCharset()));
    }

    @Singleton
    @Bean
    TypeConverter<ByteBuf, byte[]> byteBufToArrayTypeConverter() {
        return (object, targetType, context) -> Optional.of(ByteBufUtil.getBytes((ByteBuf)object));
    }

    @Singleton
    @Bean
    TypeConverter<CompositeByteBuf, byte[]> compositeByteBufTypeConverter() {
        return (object, targetType, context) -> Optional.of(ByteBufUtil.getBytes((ByteBuf)object));
    }
}

